package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class Pair extends Graph
{
Graph car;
Graph cdr;

public Pair(Graph car, Graph cdr)
{
    this.car = car;
    this.cdr = cdr;
}


public void print() throws TooManySteps
{
    if (lengthLeft < 0) throw new TooManySteps();
    Graph w = this;
    String prefix = "[";
    while (w instanceof Pair)
    {   text(prefix);
        prefix = " ";
        ((Pair)w).car.print();
        w = ((Pair)w).cdr;
    }
    if (!(w instanceof Nil))
    {   text(" . ");
        w.print();
    }
    text("]");
}


public void reduceAndPrint() throws TooManySteps
{
    if (lengthLeft < 0) throw new TooManySteps();
    Graph w = this;
    String prefix = "[";
    while (w instanceof Pair)
    {   text(prefix);
        prefix = " ";
        ((Pair)w).car.print();
        w = ((Pair)w).cdr;
        w = Graph.makeHeadNormal(w);
    }
    if (!(w instanceof Nil))
    {   text(" . ");
        w.print();
    }
    text("]");
}

boolean makeHeadNormal()
{
    return false;
}

public Graph substitute()
{
    return new Pair(car.substitute(), cdr.substitute());
}
    
}



