package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

import java.util.Hashtable;

// the class NamedObject has two uses. One is as a TEMPORARY
// item in a Graph when it is parsed but before bound variables
// have been resolved. The other is as a longer term way of
// representing globally free names (which have no real meaning or
// properties but may be used as data).
//
// After an expression has been read and parsed but before it is evaluated
// all NamedObjects that have associated values in a global environment
// will be substituted out, and that is what the "substitute" method
// here does.

public class NamedObject extends Graph
{

String name;

public NamedObject(String name)
{
    this.name = name;
}

public void print()
{
    text(name);
}

public void reduceAndPrint()
{
    text(name);
}

boolean makeHeadNormal()
{
    return false;
}

boolean eqV(String name)
{
    return (name.equals(this.name));
}
    
Graph abs(String name)
{
    if (name.equals(this.name)) return Graph.I;
    else return new Application(Graph.K, this);
}
	    

public Graph substitute()
{
    Graph val = (Graph)values.get(name);
// I leave the name intact if either there is no definition or if
// its definition is immediately itself, as in after
//     val z = z;
// (NOTE:
//     val rec z = z;
//  would define z as (Y I) not as itself.
    if (val == null ||
        val == current) return this;
    else return val;
}

public Type typeCheck(Environment e) throws NoType
{
    while (e != null)
    {   if (e.name.equals(name)) return e.type;
        e = e.tail;
    }
    Type r = (Type)types.get(name); // use a top-level def?
    if (r == null) throw new NoType();
// Graph.text("before copy "); r.debugPrint(); Graph.newline(); @@@
    r = r.copy();
// Graph.text("after copy "); r.debugPrint(); Graph.newline(); @@@
    return r;
}

}



