package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class LetExpr extends Graph
{

Definition d;
Graph b;

public LetExpr(Definition d, Graph b)
{
    this.d = d;
    this.b = b;
}

public void print() throws TooManySteps
{
    text("LET ");
    d.print();
    text(" IN ");
    b.print();
    text(" END");
}

public void reduceAndPrint() throws TooManySteps
{
    text("LET ");
    d.print();
    text(" IN ");
    b.print();
    text(" END");
}

boolean makeHeadNormal()
{
    return false;
}

public Type typeCheck(Environment e) throws NoType
{
    Environment n = d.typeCheckDef(e);
    while (n != null)
    {   e = new Environment(n.name, n.type.copy(), e);
        n = n.tail;
    }
    return b.typeCheck(e);
}

}



