package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

// For my numbers I will use Java BigIntegers so that there is no fuss
// about integer overflow.

import java.math.BigInteger;

public class Gnumber extends Graph
{

BigInteger value;

public Gnumber(long n)
{
    value = BigInteger.valueOf(n); // create one out of a long
}

public Gnumber(BigInteger n)
{
    value = n;                     // create one out of a BigInteger
}

public Gnumber(String s)
{
    value = new BigInteger(s);     // create one out of a String
}

public void print()
{
    text(value.toString());    
}

public void reduceAndPrint()
{
    text(value.toString());
}


boolean makeHeadNormal()
{
    return false;
}

public Type typeCheck(Environment e)
{
    return new Type(Type.intType);
}

}


