/* Rosemary Francis
 * 
 * This program generates a testing program for ifs and imm in N_105 assembler
 * It is only designed to be used for alu instructions. 
 * It is assumed that the instructions not being tested work trivially
 */

import java.io.*;
import java.util.*;

public class CondTestGen
{
    public static void main(String [] args)
    {
	try
	{
	    
	if(args.length != 2 && args.length != 3)
	{
	    System.out.println("Usage : java CondTestGen <prog name> <op> <options : min/max>");
	}
		
	String prog_name = args [0];
	String op = "error";
	if (args.length == 2)
		op = args [1];
	else if (args[2].compareTo("max") == 0)
		op = "movi r0 1 lsli r0 15 asri r0 15 lsri r0 1 " + args[1];
	else if (args[2].compareTo("min") == 0)
		op = "movi r0 1	lsli r0 15 " + args[1]; 

	    
	String readme = ";This file has been autonatically generated by a program called IfTestGen. \n ;Alter at your own risk! \n";
      	
	BufferedWriter out = new BufferedWriter(new FileWriter(prog_name));
	out.write(readme,0,readme.length());


	if(args[1].length()<4)
	{
	write_funtion_r(out, -5, -1, 2, op);
	write_funtion_r(out, 1, 5, 3, op);
	write_funtion_r(out, 5, 1, 4, op);
	write_funtion_r(out, -3, 6, 5, op);
	write_funtion_r(out, -8, 2, 6, op);
	write_funtion_r(out, 9, -5, 7, op);
	write_funtion_r(out, 5, -9, 8, op);
	write_funtion_r(out, -3, -3, 9, op);
	write_funtion_r(out, 3, 3, 10, op);
	write_funtion_r(out, 0, 0, 11, op);  
	write_funtion_r(out, -3, 0, 12, op); 
	write_funtion_r(out, 4, 0, 13, op);
	write_funtion_r(out, 0, -8, 14, op);
	write_funtion_r(out, 0, 5, 15, op);
	}
	else
	if (args[1].compareTo("movi") == 0 || args[1].compareTo("cmpi") == 0)
	{
	write_funtion_i(out, -1, -5, 1, op);
	write_funtion_i(out, -5, -1, 2, op);
	write_funtion_i(out, 1, 5, 3, op);
	write_funtion_i(out, 5, 1, 4, op);
	write_funtion_i(out, -3, 6, 5, op);
	write_funtion_i(out, -8, 2, 6, op);
	write_funtion_i(out, 9, -5, 7, op);
	write_funtion_i(out, 5, -9, 8, op);
	write_funtion_i(out, -3, -3, 9, op);
	write_funtion_i(out, 3, 3, 10, op);
	write_funtion_i(out, 0, 0, 11, op);  
	write_funtion_i(out, -3, 0, 12, op); 
	write_funtion_i(out, 4, 0, 13, op);
	write_funtion_i(out, 0, -8, 14, op);
	write_funtion_i(out, 0, 5, 15, op);
	}
	else
	{
	write_funtion_i(out, -39, 100, 1, op);
	write_funtion_i(out, 42, 4, 2, op);
	write_funtion_i(out, 1, 5, 3, op);
	write_funtion_i(out, -5, 1, 4, op);
	write_funtion_i(out, 28, 6, 5, op);
	write_funtion_i(out, 2, 127, 6, op);
	write_funtion_i(out, -9, 13, 7, op);
	write_funtion_i(out, 5, 0, 8, op);
	write_funtion_i(out, 12, 6, 9, op);
	write_funtion_i(out, 3, 3, 10, op);
	write_funtion_i(out, 0, 0, 11, op);  
	write_funtion_i(out, -63, 0, 12, op); 
	write_funtion_i(out, 4, 0, 13, op);
	write_funtion_i(out, 0, 77, 14, op);
	write_funtion_i(out, 0, 5, 15, op);
	}
	
	out.close();

	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

    static void write_funtion_r(BufferedWriter out, int r0, int imm, int reg, String op)
    {
	
	String line;
	String num;
	

	try
	{
		line = "movi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		    
		line = " 0 ";             
		out.write(line, 0, line.length());


		///////////////////////////////////////////////

		line = "movi r0 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " movi r1 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " " + op + " ";
		out.write(line, 0, line.length());

	       	line = "r0 r1 ifs cc_nc addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		    
		line = " 0 movi r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " movi r1 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(imm);
		out.write(num, 0, num.length());
		
		line = " " + op + " ";
		out.write(line, 0, line.length());

		line = " r0 r1 ifs cc_c addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		
		//////////////////////////////////////////////////////

		line = " 1 movi r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " movi r1 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " " + op + " ";
		out.write(line, 0, line.length());

		line = " r0 r1 ifs cc_nz addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 0 movi r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " movi r1 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " " + op + " ";
		out.write(line, 0, line.length());

		line = " r0 r1 ifs cc_z addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		line = " 2 movi r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " movi r1 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " " + op + " ";
		out.write(line, 0, line.length());

		line = " r0 r1 ifs cc_pl addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 0 movi r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " movi r1 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " " + op + " ";
		out.write(line, 0, line.length());

		line = " r0 r1 ifs cc_mi addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////
		
		line = " 4 movi r0 ";
		out.write(line, 0, line.length());

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " movi r1 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " " + op + " ";
		out.write(line, 0, line.length());

		line = " r0 r1 ifs cc_nv addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 0 movi r0 ";
		out.write(line, 0, line.length());

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());
		
		line = " movi r1 ";              
		out.write(line, 0, line.length()); 
		
		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " " + op + " ";
		out.write(line, 0, line.length());

		line = " r0 r1 ifs cc_v addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

	 	line = " 8 ";             
	 	out.write(line, 0, line.length());
	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

	static void write_funtion_i(BufferedWriter out, int r0, int imm, int reg, String op)
    {
	
	String line;
	String num;
	

	try
	{
		
		line = "movi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		    
		line = " 0 ";             
		out.write(line, 0, line.length());


		//////////////////////////////////////////////////////

		line = "movi r0 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " " + op + " r0 ";              
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

	       	line = " ifs cc_nc addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		    
		line = " 0 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());
		
		line = " ifs cc_c addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		
		//////////////////////////////////////////////////////

		line = " 1 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_nz addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 0 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_z addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		line = " 2 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length()); 

		line = " ifs cc_pl addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 0 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_mi addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		
		line = " 4 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length()); 

		line = " ifs cc_nv addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 0 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_v addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////


		line = " 8 ";             
		out.write(line, 0, line.length());
	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }
	

}






























