//Copyright (C) 1991-2004 Altera Corporation
//Any megafunction design, and related net list (encrypted or decrypted),
//support information, device programming or simulation file, and any other
//associated documentation or information provided by Altera or a partner
//under Altera's Megafunction Partnership Program may be used only to
//program PLD devices (but not masked PLD devices) from Altera.  Any other
//use of such megafunction design, net list, support information, device
//programming or simulation file, or any other related documentation or
//information is prohibited for any other purpose, including, but not
//limited to modification, reverse engineering, de-compiling, or use with
//any other silicon devices, unless such use is explicitly licensed under
//a separate agreement with Altera or a megafunction partner.  Title to
//the intellectual property, including patents, copyrights, trademarks,
//trade secrets, or maskworks, embodied in any such megafunction design,
//net list, support information, device programming or simulation file, or
//any other related documentation or information provided by Altera or a
//megafunction partner, remains with Altera, the megafunction partner, or
//their respective licensors.  No other licenses, including any licenses
//needed under any third party's intellectual property, are provided herein.
//Copying or modifying any file, or portion thereof, to which this notice
//is attached violates this copyright.

// exemplar translate_off
`timescale 1ns / 100ps
// exemplar translate_on
module lcd_16207_0 (
                     // inputs:
                      address,
                      begintransfer,
                      read,
                      write,
                      writedata,

                     // outputs:
                      LCD_E,
                      LCD_RS,
                      LCD_RW,
                      LCD_data,
                      irq,
                      readdata
                   );

  output           LCD_E;
  output           LCD_RS;
  output           LCD_RW;
  inout   [  7: 0] LCD_data;
  output           irq;
  output  [  7: 0] readdata;
  input   [  1: 0] address;
  input            begintransfer;
  input            read;
  input            write;
  input   [  7: 0] writedata;

  wire             LCD_E;
  wire             LCD_RS;
  wire             LCD_RW;
  wire    [  7: 0] LCD_data;
  wire             irq;
  wire    [  7: 0] readdata;
  assign LCD_RW = address[0];
  assign LCD_RS = address[1];
  assign LCD_E = read | write;
  assign LCD_data = (address[0]) ? 8'bz : writedata;
  assign readdata = LCD_data;


endmodule

