
module debouncer(CLK,SWITCH,reset_n);
	input CLK;
	input SWITCH;
	output reset_n;
	reg reset_n;

	reg [15:0] count;
	reg [1:0] sync;
	reg previous;
	
	always @(posedge CLK) 
	begin
		sync <= {sync[0], !SWITCH};
		previous <= sync[1];
		if ( sync[1] != previous )
			count <=0;
		else if (count[15])
			reset_n <= sync[1];
		else
			count <= count+1;
	end
endmodule