//Copyright (C) 1991-2004 Altera Corporation
//Any megafunction design, and related net list (encrypted or decrypted),
//support information, device programming or simulation file, and any other
//associated documentation or information provided by Altera or a partner
//under Altera's Megafunction Partnership Program may be used only to
//program PLD devices (but not masked PLD devices) from Altera.  Any other
//use of such megafunction design, net list, support information, device
//programming or simulation file, or any other related documentation or
//information is prohibited for any other purpose, including, but not
//limited to modification, reverse engineering, de-compiling, or use with
//any other silicon devices, unless such use is explicitly licensed under
//a separate agreement with Altera or a megafunction partner.  Title to
//the intellectual property, including patents, copyrights, trademarks,
//trade secrets, or maskworks, embodied in any such megafunction design,
//net list, support information, device programming or simulation file, or
//any other related documentation or information provided by Altera or a
//megafunction partner, remains with Altera, the megafunction partner, or
//their respective licensors.  No other licenses, including any licenses
//needed under any third party's intellectual property, are provided herein.
//Copying or modifying any file, or portion thereof, to which this notice
//is attached violates this copyright.

// exemplar translate_off
`timescale 1ns / 100ps
// exemplar translate_on
module onchip_memory_0_lane1_module (
                                      // inputs:
                                       clk,
                                       data,
                                       rdaddress,
                                       rdclken,
                                       reset_n,
                                       wraddress,
                                       wrclock,
                                       wren,

                                      // outputs:
                                       q
                                    );

  output  [  7: 0] q;
  input            clk;
  input   [  7: 0] data;
  input   [  9: 0] rdaddress;
  input            rdclken;
  input            reset_n;
  input   [  9: 0] wraddress;
  input            wrclock;
  input            wren;

  reg     [  7: 0] mem_array [1023: 0];
  wire    [  7: 0] q;
  reg     [  9: 0] read_address;

//exemplar translate_off
`ifdef MODEL_TECH
//////////////// SIMULATION-ONLY CONTENTS
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          read_address <= 0;
      else if (rdclken)
          read_address <= rdaddress;
    end


  // Data read is synchronized through latent_rdaddress.
  assign q = mem_array[read_address];

initial
    $readmemh("onchip_memory_0_lane1.dat", mem_array);
  always @(posedge wrclock)
    begin
      // Write data
      if (wren)
          mem_array[wraddress] <= data;
    end


`endif

//exemplar translate_on
//synthesis read_comments_as_HDL on
//  always @(rdaddress)
//    begin
//      if (1)
//          read_address <= rdaddress;
//    end
//
//
//  lpm_ram_dp lpm_ram_dp_component
//    (
//      .data (data),
//      .q (q),
//      .rdaddress (read_address),
//      .rdclken (rdclken),
//      .rdclock (clk),
//      .wraddress (wraddress),
//      .wrclock (wrclock),
//      .wren (wren)
//    );
//
//  defparam lpm_ram_dp_component.lpm_file = "onchip_memory_0_lane1.mif",
//           lpm_ram_dp_component.lpm_hint = "USE_EAB=ON",
//           lpm_ram_dp_component.lpm_indata = "REGISTERED",
//           lpm_ram_dp_component.lpm_outdata = "UNREGISTERED",
//           lpm_ram_dp_component.lpm_rdaddress_control = "REGISTERED",
//           lpm_ram_dp_component.lpm_width = 8,
//           lpm_ram_dp_component.lpm_widthad = 10,
//           lpm_ram_dp_component.lpm_wraddress_control = "REGISTERED",
//           lpm_ram_dp_component.suppress_memory_conversion_warnings = "ON";
//
//synthesis read_comments_as_HDL off


endmodule


module onchip_memory_0_lane0_module (
                                      // inputs:
                                       clk,
                                       data,
                                       rdaddress,
                                       rdclken,
                                       reset_n,
                                       wraddress,
                                       wrclock,
                                       wren,

                                      // outputs:
                                       q
                                    );

  output  [  7: 0] q;
  input            clk;
  input   [  7: 0] data;
  input   [  9: 0] rdaddress;
  input            rdclken;
  input            reset_n;
  input   [  9: 0] wraddress;
  input            wrclock;
  input            wren;

  reg     [  7: 0] mem_array [1023: 0];
  wire    [  7: 0] q;
  reg     [  9: 0] read_address;

//exemplar translate_off
`ifdef MODEL_TECH
//////////////// SIMULATION-ONLY CONTENTS
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          read_address <= 0;
      else if (rdclken)
          read_address <= rdaddress;
    end


  // Data read is synchronized through latent_rdaddress.
  assign q = mem_array[read_address];

initial
    $readmemh("onchip_memory_0_lane0.dat", mem_array);
  always @(posedge wrclock)
    begin
      // Write data
      if (wren)
          mem_array[wraddress] <= data;
    end


`endif

//exemplar translate_on
//synthesis read_comments_as_HDL on
//  always @(rdaddress)
//    begin
//      if (1)
//          read_address <= rdaddress;
//    end
//
//
//  lpm_ram_dp lpm_ram_dp_component
//    (
//      .data (data),
//      .q (q),
//      .rdaddress (read_address),
//      .rdclken (rdclken),
//      .rdclock (clk),
//      .wraddress (wraddress),
//      .wrclock (wrclock),
//      .wren (wren)
//    );
//
//  defparam lpm_ram_dp_component.lpm_file = "onchip_memory_0_lane0.mif",
//           lpm_ram_dp_component.lpm_hint = "USE_EAB=ON",
//           lpm_ram_dp_component.lpm_indata = "REGISTERED",
//           lpm_ram_dp_component.lpm_outdata = "UNREGISTERED",
//           lpm_ram_dp_component.lpm_rdaddress_control = "REGISTERED",
//           lpm_ram_dp_component.lpm_width = 8,
//           lpm_ram_dp_component.lpm_widthad = 10,
//           lpm_ram_dp_component.lpm_wraddress_control = "REGISTERED",
//           lpm_ram_dp_component.suppress_memory_conversion_warnings = "ON";
//
//synthesis read_comments_as_HDL off


endmodule


module onchip_memory_0 (
                         // inputs:
                          address,
                          clk,
                          reset_n,
                          writebyteenable,
                          writedata,

                         // outputs:
                          readdata
                       );

  output  [ 15: 0] readdata;
  input   [  9: 0] address;
  input            clk;
  input            reset_n;
  input   [  1: 0] writebyteenable;
  input   [ 15: 0] writedata;

  wire    [  7: 0] d_lane_0;
  wire    [  7: 0] d_lane_1;
  wire    [  9: 0] onchip_memory_0_lane0_address;
  wire    [  9: 0] onchip_memory_0_lane1_address;
  wire    [  7: 0] q_lane_0;
  wire    [  7: 0] q_lane_1;
  wire    [ 15: 0] readdata;
  wire             select_all_chunks;
  wire             write_lane_0;
  wire             write_lane_1;
  assign write_lane_1 = writebyteenable[1];
  assign select_all_chunks = 1;
  assign onchip_memory_0_lane1_address = address;
  onchip_memory_0_lane1_module onchip_memory_0_lane1
    (
      .clk       (clk),
      .data      (d_lane_1),
      .q         (q_lane_1),
      .rdaddress (onchip_memory_0_lane1_address),
      .rdclken   (1'b1),
      .reset_n   (reset_n),
      .wraddress (onchip_memory_0_lane1_address),
      .wrclock   (clk),
      .wren      (write_lane_1)
    );

  assign write_lane_0 = writebyteenable[0];
  assign select_all_chunks = 1;
  assign onchip_memory_0_lane0_address = address;
  onchip_memory_0_lane0_module onchip_memory_0_lane0
    (
      .clk       (clk),
      .data      (d_lane_0),
      .q         (q_lane_0),
      .rdaddress (onchip_memory_0_lane0_address),
      .rdclken   (1'b1),
      .reset_n   (reset_n),
      .wraddress (onchip_memory_0_lane0_address),
      .wrclock   (clk),
      .wren      (write_lane_0)
    );

  assign readdata = {q_lane_1,
    q_lane_0};

  assign {d_lane_1,
d_lane_0} = writedata;


endmodule

