//megafunction wizard: %Altera SOPC Builder%
//GENERATION: STANDARD
//VERSION: WM1.0


//Copyright (C) 1991-2004 Altera Corporation
//Any megafunction design, and related net list (encrypted or decrypted),
//support information, device programming or simulation file, and any other
//associated documentation or information provided by Altera or a partner
//under Altera's Megafunction Partnership Program may be used only to
//program PLD devices (but not masked PLD devices) from Altera.  Any other
//use of such megafunction design, net list, support information, device
//programming or simulation file, or any other related documentation or
//information is prohibited for any other purpose, including, but not
//limited to modification, reverse engineering, de-compiling, or use with
//any other silicon devices, unless such use is explicitly licensed under
//a separate agreement with Altera or a megafunction partner.  Title to
//the intellectual property, including patents, copyrights, trademarks,
//trade secrets, or maskworks, embodied in any such megafunction design,
//net list, support information, device programming or simulation file, or
//any other related documentation or information provided by Altera or a
//megafunction partner, remains with Altera, the megafunction partner, or
//their respective licensors.  No other licenses, including any licenses
//needed under any third party's intellectual property, are provided herein.
//Copying or modifying any file, or portion thereof, to which this notice
//is attached violates this copyright.

// exemplar translate_off
`timescale 1ns / 100ps
// exemplar translate_on
module cpu0_data_master_arbitrator (
                                     // inputs:
                                      cpu0_data_master_address,
                                      cpu0_data_master_granted_onchip_memory_0_s1,
                                      cpu0_data_master_qualified_request_onchip_memory_0_s1,
                                      cpu0_data_master_read,
                                      cpu0_data_master_read_data_valid_onchip_memory_0_s1,
                                      cpu0_data_master_requests_onchip_memory_0_s1,
                                      cpu0_data_master_write,
                                      cpu1_data_master_qualified_request_onchip_memory_0_s1,
                                      cpu1_data_master_s_turn_at_onchip_memory_0_s1,
                                      d1_cpu0_data_master_granted_onchip_memory_0_s1,
                                      d1_onchip_memory_0_s1_end_xfer,
                                      onchip_memory_0_s1_readdata_from_sa,

                                     // outputs:
                                      cpu0_data_master_address_to_slave,
                                      cpu0_data_master_readdata,
                                      cpu0_data_master_waitrequest
                                   );

  output  [ 15: 0] cpu0_data_master_address_to_slave;
  output  [ 15: 0] cpu0_data_master_readdata;
  output           cpu0_data_master_waitrequest;
  input   [ 15: 0] cpu0_data_master_address;
  input            cpu0_data_master_granted_onchip_memory_0_s1;
  input            cpu0_data_master_qualified_request_onchip_memory_0_s1;
  input            cpu0_data_master_read;
  input            cpu0_data_master_read_data_valid_onchip_memory_0_s1;
  input            cpu0_data_master_requests_onchip_memory_0_s1;
  input            cpu0_data_master_write;
  input            cpu1_data_master_qualified_request_onchip_memory_0_s1;
  input            cpu1_data_master_s_turn_at_onchip_memory_0_s1;
  input            d1_cpu0_data_master_granted_onchip_memory_0_s1;
  input            d1_onchip_memory_0_s1_end_xfer;
  input   [ 15: 0] onchip_memory_0_s1_readdata_from_sa;

  wire    [ 15: 0] cpu0_data_master_address_to_slave;
  wire    [ 15: 0] cpu0_data_master_readdata;
  wire             cpu0_data_master_waitrequest;
  wire             dummy_sink;
  wire             r_0;
  //r_0 cascaded wait assignment, which is an e_assign
  assign r_0 = (cpu0_data_master_qualified_request_onchip_memory_0_s1 | cpu0_data_master_read_data_valid_onchip_memory_0_s1 | ~cpu0_data_master_requests_onchip_memory_0_s1) & (!cpu0_data_master_qualified_request_onchip_memory_0_s1 |
    (cpu0_data_master_qualified_request_onchip_memory_0_s1 &
    (!cpu1_data_master_qualified_request_onchip_memory_0_s1 |
    (cpu1_data_master_qualified_request_onchip_memory_0_s1 &
    ((d1_onchip_memory_0_s1_end_xfer)?
    (!cpu1_data_master_s_turn_at_onchip_memory_0_s1) : d1_cpu0_data_master_granted_onchip_memory_0_s1
    )
    )
    )
    )) & ((~cpu0_data_master_qualified_request_onchip_memory_0_s1 | ~cpu0_data_master_read | (cpu0_data_master_read_data_valid_onchip_memory_0_s1 & cpu0_data_master_read))) & ((~cpu0_data_master_qualified_request_onchip_memory_0_s1 | ~cpu0_data_master_write | (1 & cpu0_data_master_write)));

  //cascaded wait assignment, which is an e_assign
  assign cpu0_data_master_waitrequest = ~r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign cpu0_data_master_address_to_slave = {5'b0,
    cpu0_data_master_address[10 : 0]};

  //dummy sink, which is an e_mux
  assign dummy_sink = cpu0_data_master_address_to_slave |
    cpu0_data_master_requests_onchip_memory_0_s1 |
    cpu0_data_master_qualified_request_onchip_memory_0_s1 |
    d1_onchip_memory_0_s1_end_xfer |
    cpu0_data_master_granted_onchip_memory_0_s1;

  //cpu0/data_master readdata mux, which is an e_mux
  assign cpu0_data_master_readdata = {16 {~cpu0_data_master_requests_onchip_memory_0_s1}} | onchip_memory_0_s1_readdata_from_sa;


  // exemplar attribute cpu0_data_master_arbitrator auto_dissolve FALSE

endmodule


module cpu0_instruction_master_arbitrator (
                                            // inputs:
                                             cpu0_instruction_master_address,
                                             cpu0_instruction_master_granted_onchip_memory_1_s1,
                                             cpu0_instruction_master_qualified_request_onchip_memory_1_s1,
                                             cpu0_instruction_master_read,
                                             cpu0_instruction_master_read_data_valid_onchip_memory_1_s1,
                                             cpu0_instruction_master_requests_onchip_memory_1_s1,
                                             d1_onchip_memory_1_s1_end_xfer,
                                             d2_reset_n,
                                             onchip_memory_1_s1_readdata_from_sa,

                                            // outputs:
                                             cpu0_instruction_master_address_to_slave,
                                             cpu0_instruction_master_readdata,
                                             cpu0_instruction_master_reset,
                                             cpu0_instruction_master_waitrequest
                                          );

  output  [ 15: 0] cpu0_instruction_master_address_to_slave;
  output  [ 15: 0] cpu0_instruction_master_readdata;
  output           cpu0_instruction_master_reset;
  output           cpu0_instruction_master_waitrequest;
  input   [ 15: 0] cpu0_instruction_master_address;
  input            cpu0_instruction_master_granted_onchip_memory_1_s1;
  input            cpu0_instruction_master_qualified_request_onchip_memory_1_s1;
  input            cpu0_instruction_master_read;
  input            cpu0_instruction_master_read_data_valid_onchip_memory_1_s1;
  input            cpu0_instruction_master_requests_onchip_memory_1_s1;
  input            d1_onchip_memory_1_s1_end_xfer;
  input            d2_reset_n;
  input   [ 15: 0] onchip_memory_1_s1_readdata_from_sa;

  wire    [ 15: 0] cpu0_instruction_master_address_to_slave;
  wire    [ 15: 0] cpu0_instruction_master_readdata;
  wire             cpu0_instruction_master_reset;
  wire             cpu0_instruction_master_waitrequest;
  wire             dummy_sink;
  wire             r_0;
  //r_0 cascaded wait assignment, which is an e_assign
  assign r_0 = (cpu0_instruction_master_qualified_request_onchip_memory_1_s1 | cpu0_instruction_master_read_data_valid_onchip_memory_1_s1 | ~cpu0_instruction_master_requests_onchip_memory_1_s1) & ((~cpu0_instruction_master_qualified_request_onchip_memory_1_s1 | ~cpu0_instruction_master_read | (cpu0_instruction_master_read_data_valid_onchip_memory_1_s1 & cpu0_instruction_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign cpu0_instruction_master_waitrequest = ~r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign cpu0_instruction_master_address_to_slave = {6'b10,
    cpu0_instruction_master_address[9 : 0]};

  //dummy sink, which is an e_mux
  assign dummy_sink = cpu0_instruction_master_address_to_slave |
    cpu0_instruction_master_requests_onchip_memory_1_s1 |
    cpu0_instruction_master_qualified_request_onchip_memory_1_s1 |
    cpu0_instruction_master_granted_onchip_memory_1_s1 |
    d1_onchip_memory_1_s1_end_xfer;

  //cpu0/instruction_master readdata mux, which is an e_mux
  assign cpu0_instruction_master_readdata = {16 {~cpu0_instruction_master_requests_onchip_memory_1_s1}} | onchip_memory_1_s1_readdata_from_sa;

  //reset assignment, which is an e_assign
  assign cpu0_instruction_master_reset = ~d2_reset_n;


  // exemplar attribute cpu0_instruction_master_arbitrator auto_dissolve FALSE

endmodule


module cpu1_data_master_arbitrator (
                                     // inputs:
                                      cpu0_data_master_qualified_request_onchip_memory_0_s1,
                                      cpu1_data_master_address,
                                      cpu1_data_master_granted_onchip_memory_0_s1,
                                      cpu1_data_master_qualified_request_onchip_memory_0_s1,
                                      cpu1_data_master_read,
                                      cpu1_data_master_read_data_valid_onchip_memory_0_s1,
                                      cpu1_data_master_requests_onchip_memory_0_s1,
                                      cpu1_data_master_s_turn_at_onchip_memory_0_s1,
                                      cpu1_data_master_write,
                                      d1_cpu1_data_master_granted_onchip_memory_0_s1,
                                      d1_onchip_memory_0_s1_end_xfer,
                                      onchip_memory_0_s1_readdata_from_sa,

                                     // outputs:
                                      cpu1_data_master_address_to_slave,
                                      cpu1_data_master_readdata,
                                      cpu1_data_master_waitrequest
                                   );

  output  [ 15: 0] cpu1_data_master_address_to_slave;
  output  [ 15: 0] cpu1_data_master_readdata;
  output           cpu1_data_master_waitrequest;
  input            cpu0_data_master_qualified_request_onchip_memory_0_s1;
  input   [ 15: 0] cpu1_data_master_address;
  input            cpu1_data_master_granted_onchip_memory_0_s1;
  input            cpu1_data_master_qualified_request_onchip_memory_0_s1;
  input            cpu1_data_master_read;
  input            cpu1_data_master_read_data_valid_onchip_memory_0_s1;
  input            cpu1_data_master_requests_onchip_memory_0_s1;
  input            cpu1_data_master_s_turn_at_onchip_memory_0_s1;
  input            cpu1_data_master_write;
  input            d1_cpu1_data_master_granted_onchip_memory_0_s1;
  input            d1_onchip_memory_0_s1_end_xfer;
  input   [ 15: 0] onchip_memory_0_s1_readdata_from_sa;

  wire    [ 15: 0] cpu1_data_master_address_to_slave;
  wire    [ 15: 0] cpu1_data_master_readdata;
  wire             cpu1_data_master_waitrequest;
  wire             dummy_sink;
  wire             r_0;
  //r_0 cascaded wait assignment, which is an e_assign
  assign r_0 = (cpu1_data_master_qualified_request_onchip_memory_0_s1 | cpu1_data_master_read_data_valid_onchip_memory_0_s1 | ~cpu1_data_master_requests_onchip_memory_0_s1) & (!cpu1_data_master_qualified_request_onchip_memory_0_s1 |
    (cpu1_data_master_qualified_request_onchip_memory_0_s1 &
    (!cpu0_data_master_qualified_request_onchip_memory_0_s1 |
    (cpu0_data_master_qualified_request_onchip_memory_0_s1 &
    ((d1_onchip_memory_0_s1_end_xfer)?
    cpu1_data_master_s_turn_at_onchip_memory_0_s1: d1_cpu1_data_master_granted_onchip_memory_0_s1
    )
    )
    )
    )) & ((~cpu1_data_master_qualified_request_onchip_memory_0_s1 | ~cpu1_data_master_read | (cpu1_data_master_read_data_valid_onchip_memory_0_s1 & cpu1_data_master_read))) & ((~cpu1_data_master_qualified_request_onchip_memory_0_s1 | ~cpu1_data_master_write | (1 & cpu1_data_master_write)));

  //cascaded wait assignment, which is an e_assign
  assign cpu1_data_master_waitrequest = ~r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign cpu1_data_master_address_to_slave = {5'b0,
    cpu1_data_master_address[10 : 0]};

  //dummy sink, which is an e_mux
  assign dummy_sink = cpu1_data_master_address_to_slave |
    cpu1_data_master_requests_onchip_memory_0_s1 |
    cpu1_data_master_qualified_request_onchip_memory_0_s1 |
    d1_onchip_memory_0_s1_end_xfer |
    cpu1_data_master_granted_onchip_memory_0_s1;

  //cpu1/data_master readdata mux, which is an e_mux
  assign cpu1_data_master_readdata = {16 {~cpu1_data_master_requests_onchip_memory_0_s1}} | onchip_memory_0_s1_readdata_from_sa;


  // exemplar attribute cpu1_data_master_arbitrator auto_dissolve FALSE

endmodule


module cpu1_instruction_master_arbitrator (
                                            // inputs:
                                             cpu1_instruction_master_address,
                                             cpu1_instruction_master_granted_onchip_memory_2_s1,
                                             cpu1_instruction_master_qualified_request_onchip_memory_2_s1,
                                             cpu1_instruction_master_read,
                                             cpu1_instruction_master_read_data_valid_onchip_memory_2_s1,
                                             cpu1_instruction_master_requests_onchip_memory_2_s1,
                                             d1_onchip_memory_2_s1_end_xfer,
                                             d2_reset_n,
                                             onchip_memory_2_s1_readdata_from_sa,

                                            // outputs:
                                             cpu1_instruction_master_address_to_slave,
                                             cpu1_instruction_master_readdata,
                                             cpu1_instruction_master_reset,
                                             cpu1_instruction_master_waitrequest
                                          );

  output  [ 15: 0] cpu1_instruction_master_address_to_slave;
  output  [ 15: 0] cpu1_instruction_master_readdata;
  output           cpu1_instruction_master_reset;
  output           cpu1_instruction_master_waitrequest;
  input   [ 15: 0] cpu1_instruction_master_address;
  input            cpu1_instruction_master_granted_onchip_memory_2_s1;
  input            cpu1_instruction_master_qualified_request_onchip_memory_2_s1;
  input            cpu1_instruction_master_read;
  input            cpu1_instruction_master_read_data_valid_onchip_memory_2_s1;
  input            cpu1_instruction_master_requests_onchip_memory_2_s1;
  input            d1_onchip_memory_2_s1_end_xfer;
  input            d2_reset_n;
  input   [ 15: 0] onchip_memory_2_s1_readdata_from_sa;

  wire    [ 15: 0] cpu1_instruction_master_address_to_slave;
  wire    [ 15: 0] cpu1_instruction_master_readdata;
  wire             cpu1_instruction_master_reset;
  wire             cpu1_instruction_master_waitrequest;
  wire             dummy_sink;
  wire             r_0;
  //r_0 cascaded wait assignment, which is an e_assign
  assign r_0 = (cpu1_instruction_master_qualified_request_onchip_memory_2_s1 | cpu1_instruction_master_read_data_valid_onchip_memory_2_s1 | ~cpu1_instruction_master_requests_onchip_memory_2_s1) & ((~cpu1_instruction_master_qualified_request_onchip_memory_2_s1 | ~cpu1_instruction_master_read | (cpu1_instruction_master_read_data_valid_onchip_memory_2_s1 & cpu1_instruction_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign cpu1_instruction_master_waitrequest = ~r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign cpu1_instruction_master_address_to_slave = {6'b10,
    cpu1_instruction_master_address[9 : 0]};

  //dummy sink, which is an e_mux
  assign dummy_sink = cpu1_instruction_master_address_to_slave |
    cpu1_instruction_master_requests_onchip_memory_2_s1 |
    cpu1_instruction_master_qualified_request_onchip_memory_2_s1 |
    cpu1_instruction_master_granted_onchip_memory_2_s1 |
    d1_onchip_memory_2_s1_end_xfer;

  //cpu1/instruction_master readdata mux, which is an e_mux
  assign cpu1_instruction_master_readdata = {16 {~cpu1_instruction_master_requests_onchip_memory_2_s1}} | onchip_memory_2_s1_readdata_from_sa;

  //reset assignment, which is an e_assign
  assign cpu1_instruction_master_reset = ~d2_reset_n;


  // exemplar attribute cpu1_instruction_master_arbitrator auto_dissolve FALSE

endmodule


module onchip_memory_0_s1_arbitrator (
                                       // inputs:
                                        clk,
                                        cpu0_data_master_address_to_slave,
                                        cpu0_data_master_byteenable,
                                        cpu0_data_master_read,
                                        cpu0_data_master_write,
                                        cpu0_data_master_writedata,
                                        cpu1_data_master_address_to_slave,
                                        cpu1_data_master_byteenable,
                                        cpu1_data_master_read,
                                        cpu1_data_master_write,
                                        cpu1_data_master_writedata,
                                        d2_reset_n,
                                        onchip_memory_0_s1_readdata,

                                       // outputs:
                                        cpu0_data_master_granted_onchip_memory_0_s1,
                                        cpu0_data_master_qualified_request_onchip_memory_0_s1,
                                        cpu0_data_master_read_data_valid_onchip_memory_0_s1,
                                        cpu0_data_master_requests_onchip_memory_0_s1,
                                        cpu1_data_master_granted_onchip_memory_0_s1,
                                        cpu1_data_master_qualified_request_onchip_memory_0_s1,
                                        cpu1_data_master_read_data_valid_onchip_memory_0_s1,
                                        cpu1_data_master_requests_onchip_memory_0_s1,
                                        cpu1_data_master_s_turn_at_onchip_memory_0_s1,
                                        d1_cpu0_data_master_granted_onchip_memory_0_s1,
                                        d1_cpu1_data_master_granted_onchip_memory_0_s1,
                                        d1_onchip_memory_0_s1_end_xfer,
                                        onchip_memory_0_s1_address,
                                        onchip_memory_0_s1_readdata_from_sa,
                                        onchip_memory_0_s1_reset_n,
                                        onchip_memory_0_s1_writebyteenable,
                                        onchip_memory_0_s1_writedata
                                     );

  output           cpu0_data_master_granted_onchip_memory_0_s1;
  output           cpu0_data_master_qualified_request_onchip_memory_0_s1;
  output           cpu0_data_master_read_data_valid_onchip_memory_0_s1;
  output           cpu0_data_master_requests_onchip_memory_0_s1;
  output           cpu1_data_master_granted_onchip_memory_0_s1;
  output           cpu1_data_master_qualified_request_onchip_memory_0_s1;
  output           cpu1_data_master_read_data_valid_onchip_memory_0_s1;
  output           cpu1_data_master_requests_onchip_memory_0_s1;
  output           cpu1_data_master_s_turn_at_onchip_memory_0_s1;
  output           d1_cpu0_data_master_granted_onchip_memory_0_s1;
  output           d1_cpu1_data_master_granted_onchip_memory_0_s1;
  output           d1_onchip_memory_0_s1_end_xfer;
  output  [  9: 0] onchip_memory_0_s1_address;
  output  [ 15: 0] onchip_memory_0_s1_readdata_from_sa;
  output           onchip_memory_0_s1_reset_n;
  output  [  1: 0] onchip_memory_0_s1_writebyteenable;
  output  [ 15: 0] onchip_memory_0_s1_writedata;
  input            clk;
  input   [ 15: 0] cpu0_data_master_address_to_slave;
  input   [  3: 0] cpu0_data_master_byteenable;
  input            cpu0_data_master_read;
  input            cpu0_data_master_write;
  input   [ 15: 0] cpu0_data_master_writedata;
  input   [ 15: 0] cpu1_data_master_address_to_slave;
  input   [  3: 0] cpu1_data_master_byteenable;
  input            cpu1_data_master_read;
  input            cpu1_data_master_write;
  input   [ 15: 0] cpu1_data_master_writedata;
  input            d2_reset_n;
  input   [ 15: 0] onchip_memory_0_s1_readdata;

  wire             cpu0_data_master_granted_onchip_memory_0_s1;
  wire             cpu0_data_master_qualified_request_onchip_memory_0_s1;
  wire             cpu0_data_master_read_data_valid_onchip_memory_0_s1;
  reg              cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
  wire             cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register_in;
  wire             cpu0_data_master_requests_onchip_memory_0_s1;
  wire             cpu1_data_master_granted_onchip_memory_0_s1;
  wire             cpu1_data_master_qualified_request_onchip_memory_0_s1;
  wire             cpu1_data_master_read_data_valid_onchip_memory_0_s1;
  reg              cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
  wire             cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register_in;
  wire             cpu1_data_master_requests_onchip_memory_0_s1;
  reg              cpu1_data_master_s_turn_at_onchip_memory_0_s1;
  reg              d1_cpu0_data_master_granted_onchip_memory_0_s1;
  reg              d1_cpu1_data_master_granted_onchip_memory_0_s1;
  reg              d1_onchip_memory_0_s1_end_xfer;
  reg              grant_0;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             next_grant_0;
  wire    [  9: 0] onchip_memory_0_s1_address;
  wire             onchip_memory_0_s1_dummy_write;
  wire             onchip_memory_0_s1_end_xfer;
  wire             onchip_memory_0_s1_in_a_read_cycle;
  wire             onchip_memory_0_s1_in_a_write_cycle;
  wire    [ 15: 0] onchip_memory_0_s1_readdata_from_sa;
  wire             onchip_memory_0_s1_reset_n;
  wire             onchip_memory_0_s1_waits_for_read;
  wire             onchip_memory_0_s1_waits_for_write;
  wire    [  1: 0] onchip_memory_0_s1_writebyteenable;
  wire    [  1: 0] onchip_memory_0_s1_writebyteenable_onchip_memory_0_s1_pre_write_qualification;
  wire    [ 15: 0] onchip_memory_0_s1_writedata;
  wire             p1_cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
  wire             p1_cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
  wire             wait_for_onchip_memory_0_s1_counter;
  //cpu1_data_master_granted_onchip_memory_0_s1 granted, which is an e_assign
  assign cpu1_data_master_granted_onchip_memory_0_s1 = cpu1_data_master_qualified_request_onchip_memory_0_s1 &
    (!cpu0_data_master_qualified_request_onchip_memory_0_s1 |
    (
    ((d1_onchip_memory_0_s1_end_xfer)?
    cpu1_data_master_s_turn_at_onchip_memory_0_s1 : d1_cpu1_data_master_granted_onchip_memory_0_s1
    )
    )
    );

  //cpu0_data_master_granted_onchip_memory_0_s1 granted, which is an e_assign
  assign cpu0_data_master_granted_onchip_memory_0_s1 = cpu0_data_master_qualified_request_onchip_memory_0_s1 &
    (!cpu1_data_master_qualified_request_onchip_memory_0_s1 |
    (
    ((d1_onchip_memory_0_s1_end_xfer)?
    (!cpu1_data_master_s_turn_at_onchip_memory_0_s1) : d1_cpu0_data_master_granted_onchip_memory_0_s1
    )
    )
    );

  assign cpu1_data_master_requests_onchip_memory_0_s1 = ({cpu1_data_master_address_to_slave[15 : 11] , 11'b0} == 16'h0) & (cpu1_data_master_read | cpu1_data_master_write);
  //assign onchip_memory_0_s1_readdata_from_sa = onchip_memory_0_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign onchip_memory_0_s1_readdata_from_sa = onchip_memory_0_s1_readdata;

  assign cpu1_data_master_qualified_request_onchip_memory_0_s1 = cpu1_data_master_requests_onchip_memory_0_s1 & ~((cpu1_data_master_read & ((|cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register))));
  assign cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register_in = cpu1_data_master_granted_onchip_memory_0_s1 & cpu1_data_master_read & ~onchip_memory_0_s1_waits_for_read & ~(|cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register);
  assign p1_cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register = {cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register, cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register_in};
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register <= 0;
      else if (1)
          cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register <= p1_cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
    end


  assign cpu1_data_master_read_data_valid_onchip_memory_0_s1 = cpu1_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
  //onchip_memory_0_s1_writedata mux, which is an e_mux
  assign onchip_memory_0_s1_writedata = (cpu1_data_master_granted_onchip_memory_0_s1)? cpu1_data_master_writedata :
    cpu0_data_master_writedata;

  assign cpu0_data_master_requests_onchip_memory_0_s1 = ({cpu0_data_master_address_to_slave[15 : 11] , 11'b0} == 16'h0) & (cpu0_data_master_read | cpu0_data_master_write);
  assign cpu0_data_master_qualified_request_onchip_memory_0_s1 = cpu0_data_master_requests_onchip_memory_0_s1 & ~((cpu0_data_master_read & ((|cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register))));
  assign cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register_in = cpu0_data_master_granted_onchip_memory_0_s1 & cpu0_data_master_read & ~onchip_memory_0_s1_waits_for_read & ~(|cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register);
  assign p1_cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register = {cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register, cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register_in};
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register <= 0;
      else if (1)
          cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register <= p1_cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
    end


  assign cpu0_data_master_read_data_valid_onchip_memory_0_s1 = cpu0_data_master_read_data_valid_onchip_memory_0_s1_shift_register;
  //arbitration next grant 0 assignment, which is an e_assign
  assign next_grant_0 = (grant_0 == 1) ? 0 : (grant_0 + 1);

  //onchip_memory_0_s1_end_xfer assignment, which is an e_assign
  assign onchip_memory_0_s1_end_xfer = ~(onchip_memory_0_s1_waits_for_read | onchip_memory_0_s1_waits_for_write);

  //cpu1/data_master gets granted 1
  //out of 2 times contention occurs
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          grant_0 <= 0;
      else if (onchip_memory_0_s1_end_xfer & (cpu1_data_master_qualified_request_onchip_memory_0_s1) & 
((cpu0_data_master_qualified_request_onchip_memory_0_s1)
))
          grant_0 <= next_grant_0;
    end


  //cpu1/data_master wins onchip_memory_0/s1 at begin_xfer, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          cpu1_data_master_s_turn_at_onchip_memory_0_s1 <= 0;
      else if (1)
          cpu1_data_master_s_turn_at_onchip_memory_0_s1 <= grant_0 < 1;
    end


  //d1_onchip_memory_0_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_onchip_memory_0_s1_end_xfer <= 1;
      else if (1)
          d1_onchip_memory_0_s1_end_xfer <= onchip_memory_0_s1_end_xfer;
    end


  //d1_cpu1_data_master_granted_onchip_memory_0_s1 register granted, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_cpu1_data_master_granted_onchip_memory_0_s1 <= 0;
      else if (1)
          d1_cpu1_data_master_granted_onchip_memory_0_s1 <= cpu1_data_master_granted_onchip_memory_0_s1;
    end


  //d1_cpu0_data_master_granted_onchip_memory_0_s1 register granted, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_cpu0_data_master_granted_onchip_memory_0_s1 <= 0;
      else if (1)
          d1_cpu0_data_master_granted_onchip_memory_0_s1 <= cpu0_data_master_granted_onchip_memory_0_s1;
    end


  //onchip_memory_0_s1_address mux, which is an e_mux
  assign onchip_memory_0_s1_address = (cpu1_data_master_granted_onchip_memory_0_s1)? (cpu1_data_master_address_to_slave >> 1) :
    (cpu0_data_master_address_to_slave >> 1);

  //onchip_memory_0_s1_dummy_write assignment, which is an e_mux
  assign onchip_memory_0_s1_dummy_write = (cpu1_data_master_granted_onchip_memory_0_s1 & cpu1_data_master_write) | (cpu0_data_master_granted_onchip_memory_0_s1 & cpu0_data_master_write);

  assign onchip_memory_0_s1_waits_for_read = onchip_memory_0_s1_in_a_read_cycle & 0;
  //onchip_memory_0_s1_in_a_read_cycle assignment, which is an e_assign
  assign onchip_memory_0_s1_in_a_read_cycle = (cpu1_data_master_granted_onchip_memory_0_s1 & cpu1_data_master_read) | (cpu0_data_master_granted_onchip_memory_0_s1 & cpu0_data_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = onchip_memory_0_s1_in_a_read_cycle;

  assign onchip_memory_0_s1_waits_for_write = onchip_memory_0_s1_in_a_write_cycle & 0;
  //onchip_memory_0_s1_in_a_write_cycle assignment, which is an e_assign
  assign onchip_memory_0_s1_in_a_write_cycle = (cpu1_data_master_granted_onchip_memory_0_s1 & cpu1_data_master_write) | (cpu0_data_master_granted_onchip_memory_0_s1 & cpu0_data_master_write);

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = onchip_memory_0_s1_in_a_write_cycle;

  assign wait_for_onchip_memory_0_s1_counter = 0;
  //onchip_memory_0_s1_writebyteenable qualified byte write enables, which is an e_mux
  assign onchip_memory_0_s1_writebyteenable = ((onchip_memory_0_s1_dummy_write & cpu1_data_master_granted_onchip_memory_0_s1))? onchip_memory_0_s1_writebyteenable_onchip_memory_0_s1_pre_write_qualification :
    ((onchip_memory_0_s1_dummy_write & cpu0_data_master_granted_onchip_memory_0_s1))? onchip_memory_0_s1_writebyteenable_onchip_memory_0_s1_pre_write_qualification :
    0;

  //onchip_memory_0_s1_writebyteenable_onchip_memory_0_s1_pre_write_qualification mux, which is an e_mux
  assign onchip_memory_0_s1_writebyteenable_onchip_memory_0_s1_pre_write_qualification = (cpu1_data_master_granted_onchip_memory_0_s1)? cpu1_data_master_byteenable :
    (cpu0_data_master_granted_onchip_memory_0_s1)? cpu0_data_master_byteenable :
    -1;

  assign onchip_memory_0_s1_reset_n = d2_reset_n;

  // exemplar attribute onchip_memory_0_s1_arbitrator auto_dissolve FALSE

endmodule


module onchip_memory_1_s1_arbitrator (
                                       // inputs:
                                        clk,
                                        cpu0_instruction_master_address_to_slave,
                                        cpu0_instruction_master_read,
                                        d2_reset_n,
                                        onchip_memory_1_s1_readdata,

                                       // outputs:
                                        cpu0_instruction_master_granted_onchip_memory_1_s1,
                                        cpu0_instruction_master_qualified_request_onchip_memory_1_s1,
                                        cpu0_instruction_master_read_data_valid_onchip_memory_1_s1,
                                        cpu0_instruction_master_requests_onchip_memory_1_s1,
                                        d1_onchip_memory_1_s1_end_xfer,
                                        onchip_memory_1_s1_address,
                                        onchip_memory_1_s1_readdata_from_sa,
                                        onchip_memory_1_s1_reset_n
                                     );

  output           cpu0_instruction_master_granted_onchip_memory_1_s1;
  output           cpu0_instruction_master_qualified_request_onchip_memory_1_s1;
  output           cpu0_instruction_master_read_data_valid_onchip_memory_1_s1;
  output           cpu0_instruction_master_requests_onchip_memory_1_s1;
  output           d1_onchip_memory_1_s1_end_xfer;
  output  [  8: 0] onchip_memory_1_s1_address;
  output  [ 15: 0] onchip_memory_1_s1_readdata_from_sa;
  output           onchip_memory_1_s1_reset_n;
  input            clk;
  input   [ 15: 0] cpu0_instruction_master_address_to_slave;
  input            cpu0_instruction_master_read;
  input            d2_reset_n;
  input   [ 15: 0] onchip_memory_1_s1_readdata;

  wire             cpu0_instruction_master_granted_onchip_memory_1_s1;
  wire             cpu0_instruction_master_qualified_request_onchip_memory_1_s1;
  wire             cpu0_instruction_master_read_data_valid_onchip_memory_1_s1;
  reg              cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register;
  wire             cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register_in;
  wire             cpu0_instruction_master_requests_onchip_memory_1_s1;
  reg              d1_onchip_memory_1_s1_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  8: 0] onchip_memory_1_s1_address;
  wire             onchip_memory_1_s1_end_xfer;
  wire             onchip_memory_1_s1_in_a_read_cycle;
  wire             onchip_memory_1_s1_in_a_write_cycle;
  wire    [ 15: 0] onchip_memory_1_s1_readdata_from_sa;
  wire             onchip_memory_1_s1_reset_n;
  wire             onchip_memory_1_s1_waits_for_read;
  wire             onchip_memory_1_s1_waits_for_write;
  wire             p1_cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register;
  wire             wait_for_onchip_memory_1_s1_counter;
  assign cpu0_instruction_master_requests_onchip_memory_1_s1 = ({cpu0_instruction_master_address_to_slave[15 : 10] , 10'b0} == 16'h800) & (cpu0_instruction_master_read);
  //assign onchip_memory_1_s1_readdata_from_sa = onchip_memory_1_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign onchip_memory_1_s1_readdata_from_sa = onchip_memory_1_s1_readdata;

  assign cpu0_instruction_master_qualified_request_onchip_memory_1_s1 = cpu0_instruction_master_requests_onchip_memory_1_s1 & ~((cpu0_instruction_master_read & ((|cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register))));
  assign cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register_in = cpu0_instruction_master_granted_onchip_memory_1_s1 & cpu0_instruction_master_read & ~onchip_memory_1_s1_waits_for_read & ~(|cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register);
  assign p1_cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register = {cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register, cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register_in};
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register <= 0;
      else if (1)
          cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register <= p1_cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register;
    end


  assign cpu0_instruction_master_read_data_valid_onchip_memory_1_s1 = cpu0_instruction_master_read_data_valid_onchip_memory_1_s1_shift_register;
  //master is always granted when requested
  assign cpu0_instruction_master_granted_onchip_memory_1_s1 = cpu0_instruction_master_qualified_request_onchip_memory_1_s1;

  //onchip_memory_1_s1_address mux, which is an e_mux
  assign onchip_memory_1_s1_address = cpu0_instruction_master_address_to_slave >> 1;

  //onchip_memory_1_s1_end_xfer assignment, which is an e_assign
  assign onchip_memory_1_s1_end_xfer = ~(onchip_memory_1_s1_waits_for_read | onchip_memory_1_s1_waits_for_write);

  //d1_onchip_memory_1_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_onchip_memory_1_s1_end_xfer <= 1;
      else if (1)
          d1_onchip_memory_1_s1_end_xfer <= onchip_memory_1_s1_end_xfer;
    end


  assign onchip_memory_1_s1_waits_for_read = onchip_memory_1_s1_in_a_read_cycle & 0;
  //onchip_memory_1_s1_in_a_read_cycle assignment, which is an e_assign
  assign onchip_memory_1_s1_in_a_read_cycle = cpu0_instruction_master_granted_onchip_memory_1_s1 & cpu0_instruction_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = onchip_memory_1_s1_in_a_read_cycle;

  assign onchip_memory_1_s1_waits_for_write = onchip_memory_1_s1_in_a_write_cycle & 0;
  //onchip_memory_1_s1_in_a_write_cycle assignment, which is an e_assign
  assign onchip_memory_1_s1_in_a_write_cycle = 0;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = onchip_memory_1_s1_in_a_write_cycle;

  assign wait_for_onchip_memory_1_s1_counter = 0;
  assign onchip_memory_1_s1_reset_n = d2_reset_n;

  // exemplar attribute onchip_memory_1_s1_arbitrator auto_dissolve FALSE

endmodule


module onchip_memory_2_s1_arbitrator (
                                       // inputs:
                                        clk,
                                        cpu1_instruction_master_address_to_slave,
                                        cpu1_instruction_master_read,
                                        d2_reset_n,
                                        onchip_memory_2_s1_readdata,

                                       // outputs:
                                        cpu1_instruction_master_granted_onchip_memory_2_s1,
                                        cpu1_instruction_master_qualified_request_onchip_memory_2_s1,
                                        cpu1_instruction_master_read_data_valid_onchip_memory_2_s1,
                                        cpu1_instruction_master_requests_onchip_memory_2_s1,
                                        d1_onchip_memory_2_s1_end_xfer,
                                        onchip_memory_2_s1_address,
                                        onchip_memory_2_s1_readdata_from_sa,
                                        onchip_memory_2_s1_reset_n
                                     );

  output           cpu1_instruction_master_granted_onchip_memory_2_s1;
  output           cpu1_instruction_master_qualified_request_onchip_memory_2_s1;
  output           cpu1_instruction_master_read_data_valid_onchip_memory_2_s1;
  output           cpu1_instruction_master_requests_onchip_memory_2_s1;
  output           d1_onchip_memory_2_s1_end_xfer;
  output  [  8: 0] onchip_memory_2_s1_address;
  output  [ 15: 0] onchip_memory_2_s1_readdata_from_sa;
  output           onchip_memory_2_s1_reset_n;
  input            clk;
  input   [ 15: 0] cpu1_instruction_master_address_to_slave;
  input            cpu1_instruction_master_read;
  input            d2_reset_n;
  input   [ 15: 0] onchip_memory_2_s1_readdata;

  wire             cpu1_instruction_master_granted_onchip_memory_2_s1;
  wire             cpu1_instruction_master_qualified_request_onchip_memory_2_s1;
  wire             cpu1_instruction_master_read_data_valid_onchip_memory_2_s1;
  reg              cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register;
  wire             cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register_in;
  wire             cpu1_instruction_master_requests_onchip_memory_2_s1;
  reg              d1_onchip_memory_2_s1_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  8: 0] onchip_memory_2_s1_address;
  wire             onchip_memory_2_s1_end_xfer;
  wire             onchip_memory_2_s1_in_a_read_cycle;
  wire             onchip_memory_2_s1_in_a_write_cycle;
  wire    [ 15: 0] onchip_memory_2_s1_readdata_from_sa;
  wire             onchip_memory_2_s1_reset_n;
  wire             onchip_memory_2_s1_waits_for_read;
  wire             onchip_memory_2_s1_waits_for_write;
  wire             p1_cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register;
  wire             wait_for_onchip_memory_2_s1_counter;
  assign cpu1_instruction_master_requests_onchip_memory_2_s1 = ({cpu1_instruction_master_address_to_slave[15 : 10] , 10'b0} == 16'h800) & (cpu1_instruction_master_read);
  //assign onchip_memory_2_s1_readdata_from_sa = onchip_memory_2_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign onchip_memory_2_s1_readdata_from_sa = onchip_memory_2_s1_readdata;

  assign cpu1_instruction_master_qualified_request_onchip_memory_2_s1 = cpu1_instruction_master_requests_onchip_memory_2_s1 & ~((cpu1_instruction_master_read & ((|cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register))));
  assign cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register_in = cpu1_instruction_master_granted_onchip_memory_2_s1 & cpu1_instruction_master_read & ~onchip_memory_2_s1_waits_for_read & ~(|cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register);
  assign p1_cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register = {cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register, cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register_in};
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register <= 0;
      else if (1)
          cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register <= p1_cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register;
    end


  assign cpu1_instruction_master_read_data_valid_onchip_memory_2_s1 = cpu1_instruction_master_read_data_valid_onchip_memory_2_s1_shift_register;
  //master is always granted when requested
  assign cpu1_instruction_master_granted_onchip_memory_2_s1 = cpu1_instruction_master_qualified_request_onchip_memory_2_s1;

  //onchip_memory_2_s1_address mux, which is an e_mux
  assign onchip_memory_2_s1_address = cpu1_instruction_master_address_to_slave >> 1;

  //onchip_memory_2_s1_end_xfer assignment, which is an e_assign
  assign onchip_memory_2_s1_end_xfer = ~(onchip_memory_2_s1_waits_for_read | onchip_memory_2_s1_waits_for_write);

  //d1_onchip_memory_2_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_onchip_memory_2_s1_end_xfer <= 1;
      else if (1)
          d1_onchip_memory_2_s1_end_xfer <= onchip_memory_2_s1_end_xfer;
    end


  assign onchip_memory_2_s1_waits_for_read = onchip_memory_2_s1_in_a_read_cycle & 0;
  //onchip_memory_2_s1_in_a_read_cycle assignment, which is an e_assign
  assign onchip_memory_2_s1_in_a_read_cycle = cpu1_instruction_master_granted_onchip_memory_2_s1 & cpu1_instruction_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = onchip_memory_2_s1_in_a_read_cycle;

  assign onchip_memory_2_s1_waits_for_write = onchip_memory_2_s1_in_a_write_cycle & 0;
  //onchip_memory_2_s1_in_a_write_cycle assignment, which is an e_assign
  assign onchip_memory_2_s1_in_a_write_cycle = 0;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = onchip_memory_2_s1_in_a_write_cycle;

  assign wait_for_onchip_memory_2_s1_counter = 0;
  assign onchip_memory_2_s1_reset_n = d2_reset_n;

  // exemplar attribute onchip_memory_2_s1_arbitrator auto_dissolve FALSE

endmodule


module n105_cluster (
                      // 1) global signals:
                       clk,
                       reset_n
                    );

  input            clk;
  input            reset_n;

  wire             always_one;
  wire    [ 15: 0] cpu0_data_master_address;
  wire    [ 15: 0] cpu0_data_master_address_to_slave;
  wire    [  3: 0] cpu0_data_master_byteenable;
  wire             cpu0_data_master_granted_onchip_memory_0_s1;
  wire             cpu0_data_master_qualified_request_onchip_memory_0_s1;
  wire             cpu0_data_master_read;
  wire             cpu0_data_master_read_data_valid_onchip_memory_0_s1;
  wire    [ 15: 0] cpu0_data_master_readdata;
  wire             cpu0_data_master_requests_onchip_memory_0_s1;
  wire             cpu0_data_master_waitrequest;
  wire             cpu0_data_master_write;
  wire    [ 15: 0] cpu0_data_master_writedata;
  wire    [ 15: 0] cpu0_instruction_master_address;
  wire    [ 15: 0] cpu0_instruction_master_address_to_slave;
  wire    [  3: 0] cpu0_instruction_master_byteenable;
  wire             cpu0_instruction_master_granted_onchip_memory_1_s1;
  wire             cpu0_instruction_master_qualified_request_onchip_memory_1_s1;
  wire             cpu0_instruction_master_read;
  wire             cpu0_instruction_master_read_data_valid_onchip_memory_1_s1;
  wire    [ 15: 0] cpu0_instruction_master_readdata;
  wire             cpu0_instruction_master_requests_onchip_memory_1_s1;
  wire             cpu0_instruction_master_reset;
  wire             cpu0_instruction_master_waitrequest;
  wire    [ 15: 0] cpu1_data_master_address;
  wire    [ 15: 0] cpu1_data_master_address_to_slave;
  wire    [  3: 0] cpu1_data_master_byteenable;
  wire             cpu1_data_master_granted_onchip_memory_0_s1;
  wire             cpu1_data_master_qualified_request_onchip_memory_0_s1;
  wire             cpu1_data_master_read;
  wire             cpu1_data_master_read_data_valid_onchip_memory_0_s1;
  wire    [ 15: 0] cpu1_data_master_readdata;
  wire             cpu1_data_master_requests_onchip_memory_0_s1;
  wire             cpu1_data_master_s_turn_at_onchip_memory_0_s1;
  wire             cpu1_data_master_waitrequest;
  wire             cpu1_data_master_write;
  wire    [ 15: 0] cpu1_data_master_writedata;
  wire    [ 15: 0] cpu1_instruction_master_address;
  wire    [ 15: 0] cpu1_instruction_master_address_to_slave;
  wire    [  3: 0] cpu1_instruction_master_byteenable;
  wire             cpu1_instruction_master_granted_onchip_memory_2_s1;
  wire             cpu1_instruction_master_qualified_request_onchip_memory_2_s1;
  wire             cpu1_instruction_master_read;
  wire             cpu1_instruction_master_read_data_valid_onchip_memory_2_s1;
  wire    [ 15: 0] cpu1_instruction_master_readdata;
  wire             cpu1_instruction_master_requests_onchip_memory_2_s1;
  wire             cpu1_instruction_master_reset;
  wire             cpu1_instruction_master_waitrequest;
  wire             d1_cpu0_data_master_granted_onchip_memory_0_s1;
  wire             d1_cpu1_data_master_granted_onchip_memory_0_s1;
  wire             d1_onchip_memory_0_s1_end_xfer;
  wire             d1_onchip_memory_1_s1_end_xfer;
  wire             d1_onchip_memory_2_s1_end_xfer;
  reg              d1_reset_n_sources;
  reg              d2_reset_n;
  wire    [  9: 0] onchip_memory_0_s1_address;
  wire    [ 15: 0] onchip_memory_0_s1_readdata;
  wire    [ 15: 0] onchip_memory_0_s1_readdata_from_sa;
  wire             onchip_memory_0_s1_reset_n;
  wire    [  1: 0] onchip_memory_0_s1_writebyteenable;
  wire    [ 15: 0] onchip_memory_0_s1_writedata;
  wire    [  8: 0] onchip_memory_1_s1_address;
  wire    [ 15: 0] onchip_memory_1_s1_readdata;
  wire    [ 15: 0] onchip_memory_1_s1_readdata_from_sa;
  wire             onchip_memory_1_s1_reset_n;
  wire    [  8: 0] onchip_memory_2_s1_address;
  wire    [ 15: 0] onchip_memory_2_s1_readdata;
  wire    [ 15: 0] onchip_memory_2_s1_readdata_from_sa;
  wire             onchip_memory_2_s1_reset_n;
  wire             reset_n_sources;
  cpu0_data_master_arbitrator the_cpu0_data_master
    (
      .cpu0_data_master_address                              (cpu0_data_master_address),
      .cpu0_data_master_address_to_slave                     (cpu0_data_master_address_to_slave),
      .cpu0_data_master_granted_onchip_memory_0_s1           (cpu0_data_master_granted_onchip_memory_0_s1),
      .cpu0_data_master_qualified_request_onchip_memory_0_s1 (cpu0_data_master_qualified_request_onchip_memory_0_s1),
      .cpu0_data_master_read                                 (cpu0_data_master_read),
      .cpu0_data_master_read_data_valid_onchip_memory_0_s1   (cpu0_data_master_read_data_valid_onchip_memory_0_s1),
      .cpu0_data_master_readdata                             (cpu0_data_master_readdata),
      .cpu0_data_master_requests_onchip_memory_0_s1          (cpu0_data_master_requests_onchip_memory_0_s1),
      .cpu0_data_master_waitrequest                          (cpu0_data_master_waitrequest),
      .cpu0_data_master_write                                (cpu0_data_master_write),
      .cpu1_data_master_qualified_request_onchip_memory_0_s1 (cpu1_data_master_qualified_request_onchip_memory_0_s1),
      .cpu1_data_master_s_turn_at_onchip_memory_0_s1         (cpu1_data_master_s_turn_at_onchip_memory_0_s1),
      .d1_cpu0_data_master_granted_onchip_memory_0_s1        (d1_cpu0_data_master_granted_onchip_memory_0_s1),
      .d1_onchip_memory_0_s1_end_xfer                        (d1_onchip_memory_0_s1_end_xfer),
      .onchip_memory_0_s1_readdata_from_sa                   (onchip_memory_0_s1_readdata_from_sa)
    );

  cpu0_instruction_master_arbitrator the_cpu0_instruction_master
    (
      .cpu0_instruction_master_address                              (cpu0_instruction_master_address),
      .cpu0_instruction_master_address_to_slave                     (cpu0_instruction_master_address_to_slave),
      .cpu0_instruction_master_granted_onchip_memory_1_s1           (cpu0_instruction_master_granted_onchip_memory_1_s1),
      .cpu0_instruction_master_qualified_request_onchip_memory_1_s1 (cpu0_instruction_master_qualified_request_onchip_memory_1_s1),
      .cpu0_instruction_master_read                                 (cpu0_instruction_master_read),
      .cpu0_instruction_master_read_data_valid_onchip_memory_1_s1   (cpu0_instruction_master_read_data_valid_onchip_memory_1_s1),
      .cpu0_instruction_master_readdata                             (cpu0_instruction_master_readdata),
      .cpu0_instruction_master_requests_onchip_memory_1_s1          (cpu0_instruction_master_requests_onchip_memory_1_s1),
      .cpu0_instruction_master_reset                                (cpu0_instruction_master_reset),
      .cpu0_instruction_master_waitrequest                          (cpu0_instruction_master_waitrequest),
      .d1_onchip_memory_1_s1_end_xfer                               (d1_onchip_memory_1_s1_end_xfer),
      .d2_reset_n                                                   (d2_reset_n),
      .onchip_memory_1_s1_readdata_from_sa                          (onchip_memory_1_s1_readdata_from_sa)
    );

  cpu0 the_cpu0
    (
      .address_instr_fetch     (cpu0_instruction_master_address),
      .address_mem_access      (cpu0_data_master_address),
      .byteenable_instr_fetch  (cpu0_instruction_master_byteenable),
      .byteenable_mem_access   (cpu0_data_master_byteenable),
      .clk                     (clk),
      .read_instr_fetch        (cpu0_instruction_master_read),
      .read_mem_access         (cpu0_data_master_read),
      .readdata_instr_fetch    (cpu0_instruction_master_readdata),
      .readdata_mem_access     (cpu0_data_master_readdata),
      .reset                   (cpu0_instruction_master_reset),
      .waitrequest_instr_fetch (cpu0_instruction_master_waitrequest),
      .waitrequest_mem_access  (cpu0_data_master_waitrequest),
      .write_mem_access        (cpu0_data_master_write),
      .writedata_mem_access    (cpu0_data_master_writedata)
    );

  cpu1_data_master_arbitrator the_cpu1_data_master
    (
      .cpu0_data_master_qualified_request_onchip_memory_0_s1 (cpu0_data_master_qualified_request_onchip_memory_0_s1),
      .cpu1_data_master_address                              (cpu1_data_master_address),
      .cpu1_data_master_address_to_slave                     (cpu1_data_master_address_to_slave),
      .cpu1_data_master_granted_onchip_memory_0_s1           (cpu1_data_master_granted_onchip_memory_0_s1),
      .cpu1_data_master_qualified_request_onchip_memory_0_s1 (cpu1_data_master_qualified_request_onchip_memory_0_s1),
      .cpu1_data_master_read                                 (cpu1_data_master_read),
      .cpu1_data_master_read_data_valid_onchip_memory_0_s1   (cpu1_data_master_read_data_valid_onchip_memory_0_s1),
      .cpu1_data_master_readdata                             (cpu1_data_master_readdata),
      .cpu1_data_master_requests_onchip_memory_0_s1          (cpu1_data_master_requests_onchip_memory_0_s1),
      .cpu1_data_master_s_turn_at_onchip_memory_0_s1         (cpu1_data_master_s_turn_at_onchip_memory_0_s1),
      .cpu1_data_master_waitrequest                          (cpu1_data_master_waitrequest),
      .cpu1_data_master_write                                (cpu1_data_master_write),
      .d1_cpu1_data_master_granted_onchip_memory_0_s1        (d1_cpu1_data_master_granted_onchip_memory_0_s1),
      .d1_onchip_memory_0_s1_end_xfer                        (d1_onchip_memory_0_s1_end_xfer),
      .onchip_memory_0_s1_readdata_from_sa                   (onchip_memory_0_s1_readdata_from_sa)
    );

  cpu1_instruction_master_arbitrator the_cpu1_instruction_master
    (
      .cpu1_instruction_master_address                              (cpu1_instruction_master_address),
      .cpu1_instruction_master_address_to_slave                     (cpu1_instruction_master_address_to_slave),
      .cpu1_instruction_master_granted_onchip_memory_2_s1           (cpu1_instruction_master_granted_onchip_memory_2_s1),
      .cpu1_instruction_master_qualified_request_onchip_memory_2_s1 (cpu1_instruction_master_qualified_request_onchip_memory_2_s1),
      .cpu1_instruction_master_read                                 (cpu1_instruction_master_read),
      .cpu1_instruction_master_read_data_valid_onchip_memory_2_s1   (cpu1_instruction_master_read_data_valid_onchip_memory_2_s1),
      .cpu1_instruction_master_readdata                             (cpu1_instruction_master_readdata),
      .cpu1_instruction_master_requests_onchip_memory_2_s1          (cpu1_instruction_master_requests_onchip_memory_2_s1),
      .cpu1_instruction_master_reset                                (cpu1_instruction_master_reset),
      .cpu1_instruction_master_waitrequest                          (cpu1_instruction_master_waitrequest),
      .d1_onchip_memory_2_s1_end_xfer                               (d1_onchip_memory_2_s1_end_xfer),
      .d2_reset_n                                                   (d2_reset_n),
      .onchip_memory_2_s1_readdata_from_sa                          (onchip_memory_2_s1_readdata_from_sa)
    );

  cpu1 the_cpu1
    (
      .address_instr_fetch     (cpu1_instruction_master_address),
      .address_mem_access      (cpu1_data_master_address),
      .byteenable_instr_fetch  (cpu1_instruction_master_byteenable),
      .byteenable_mem_access   (cpu1_data_master_byteenable),
      .clk                     (clk),
      .read_instr_fetch        (cpu1_instruction_master_read),
      .read_mem_access         (cpu1_data_master_read),
      .readdata_instr_fetch    (cpu1_instruction_master_readdata),
      .readdata_mem_access     (cpu1_data_master_readdata),
      .reset                   (cpu1_instruction_master_reset),
      .waitrequest_instr_fetch (cpu1_instruction_master_waitrequest),
      .waitrequest_mem_access  (cpu1_data_master_waitrequest),
      .write_mem_access        (cpu1_data_master_write),
      .writedata_mem_access    (cpu1_data_master_writedata)
    );

  onchip_memory_0_s1_arbitrator the_onchip_memory_0_s1
    (
      .clk                                                   (clk),
      .cpu0_data_master_address_to_slave                     (cpu0_data_master_address_to_slave),
      .cpu0_data_master_byteenable                           (cpu0_data_master_byteenable),
      .cpu0_data_master_granted_onchip_memory_0_s1           (cpu0_data_master_granted_onchip_memory_0_s1),
      .cpu0_data_master_qualified_request_onchip_memory_0_s1 (cpu0_data_master_qualified_request_onchip_memory_0_s1),
      .cpu0_data_master_read                                 (cpu0_data_master_read),
      .cpu0_data_master_read_data_valid_onchip_memory_0_s1   (cpu0_data_master_read_data_valid_onchip_memory_0_s1),
      .cpu0_data_master_requests_onchip_memory_0_s1          (cpu0_data_master_requests_onchip_memory_0_s1),
      .cpu0_data_master_write                                (cpu0_data_master_write),
      .cpu0_data_master_writedata                            (cpu0_data_master_writedata),
      .cpu1_data_master_address_to_slave                     (cpu1_data_master_address_to_slave),
      .cpu1_data_master_byteenable                           (cpu1_data_master_byteenable),
      .cpu1_data_master_granted_onchip_memory_0_s1           (cpu1_data_master_granted_onchip_memory_0_s1),
      .cpu1_data_master_qualified_request_onchip_memory_0_s1 (cpu1_data_master_qualified_request_onchip_memory_0_s1),
      .cpu1_data_master_read                                 (cpu1_data_master_read),
      .cpu1_data_master_read_data_valid_onchip_memory_0_s1   (cpu1_data_master_read_data_valid_onchip_memory_0_s1),
      .cpu1_data_master_requests_onchip_memory_0_s1          (cpu1_data_master_requests_onchip_memory_0_s1),
      .cpu1_data_master_s_turn_at_onchip_memory_0_s1         (cpu1_data_master_s_turn_at_onchip_memory_0_s1),
      .cpu1_data_master_write                                (cpu1_data_master_write),
      .cpu1_data_master_writedata                            (cpu1_data_master_writedata),
      .d1_cpu0_data_master_granted_onchip_memory_0_s1        (d1_cpu0_data_master_granted_onchip_memory_0_s1),
      .d1_cpu1_data_master_granted_onchip_memory_0_s1        (d1_cpu1_data_master_granted_onchip_memory_0_s1),
      .d1_onchip_memory_0_s1_end_xfer                        (d1_onchip_memory_0_s1_end_xfer),
      .d2_reset_n                                            (d2_reset_n),
      .onchip_memory_0_s1_address                            (onchip_memory_0_s1_address),
      .onchip_memory_0_s1_readdata                           (onchip_memory_0_s1_readdata),
      .onchip_memory_0_s1_readdata_from_sa                   (onchip_memory_0_s1_readdata_from_sa),
      .onchip_memory_0_s1_reset_n                            (onchip_memory_0_s1_reset_n),
      .onchip_memory_0_s1_writebyteenable                    (onchip_memory_0_s1_writebyteenable),
      .onchip_memory_0_s1_writedata                          (onchip_memory_0_s1_writedata)
    );

  onchip_memory_0 the_onchip_memory_0
    (
      .address         (onchip_memory_0_s1_address),
      .clk             (clk),
      .readdata        (onchip_memory_0_s1_readdata),
      .reset_n         (onchip_memory_0_s1_reset_n),
      .writebyteenable (onchip_memory_0_s1_writebyteenable),
      .writedata       (onchip_memory_0_s1_writedata)
    );

  onchip_memory_1_s1_arbitrator the_onchip_memory_1_s1
    (
      .clk                                                          (clk),
      .cpu0_instruction_master_address_to_slave                     (cpu0_instruction_master_address_to_slave),
      .cpu0_instruction_master_granted_onchip_memory_1_s1           (cpu0_instruction_master_granted_onchip_memory_1_s1),
      .cpu0_instruction_master_qualified_request_onchip_memory_1_s1 (cpu0_instruction_master_qualified_request_onchip_memory_1_s1),
      .cpu0_instruction_master_read                                 (cpu0_instruction_master_read),
      .cpu0_instruction_master_read_data_valid_onchip_memory_1_s1   (cpu0_instruction_master_read_data_valid_onchip_memory_1_s1),
      .cpu0_instruction_master_requests_onchip_memory_1_s1          (cpu0_instruction_master_requests_onchip_memory_1_s1),
      .d1_onchip_memory_1_s1_end_xfer                               (d1_onchip_memory_1_s1_end_xfer),
      .d2_reset_n                                                   (d2_reset_n),
      .onchip_memory_1_s1_address                                   (onchip_memory_1_s1_address),
      .onchip_memory_1_s1_readdata                                  (onchip_memory_1_s1_readdata),
      .onchip_memory_1_s1_readdata_from_sa                          (onchip_memory_1_s1_readdata_from_sa),
      .onchip_memory_1_s1_reset_n                                   (onchip_memory_1_s1_reset_n)
    );

  onchip_memory_1 the_onchip_memory_1
    (
      .address  (onchip_memory_1_s1_address),
      .clk      (clk),
      .readdata (onchip_memory_1_s1_readdata),
      .reset_n  (onchip_memory_1_s1_reset_n)
    );

  onchip_memory_2_s1_arbitrator the_onchip_memory_2_s1
    (
      .clk                                                          (clk),
      .cpu1_instruction_master_address_to_slave                     (cpu1_instruction_master_address_to_slave),
      .cpu1_instruction_master_granted_onchip_memory_2_s1           (cpu1_instruction_master_granted_onchip_memory_2_s1),
      .cpu1_instruction_master_qualified_request_onchip_memory_2_s1 (cpu1_instruction_master_qualified_request_onchip_memory_2_s1),
      .cpu1_instruction_master_read                                 (cpu1_instruction_master_read),
      .cpu1_instruction_master_read_data_valid_onchip_memory_2_s1   (cpu1_instruction_master_read_data_valid_onchip_memory_2_s1),
      .cpu1_instruction_master_requests_onchip_memory_2_s1          (cpu1_instruction_master_requests_onchip_memory_2_s1),
      .d1_onchip_memory_2_s1_end_xfer                               (d1_onchip_memory_2_s1_end_xfer),
      .d2_reset_n                                                   (d2_reset_n),
      .onchip_memory_2_s1_address                                   (onchip_memory_2_s1_address),
      .onchip_memory_2_s1_readdata                                  (onchip_memory_2_s1_readdata),
      .onchip_memory_2_s1_readdata_from_sa                          (onchip_memory_2_s1_readdata_from_sa),
      .onchip_memory_2_s1_reset_n                                   (onchip_memory_2_s1_reset_n)
    );

  onchip_memory_2 the_onchip_memory_2
    (
      .address  (onchip_memory_2_s1_address),
      .clk      (clk),
      .readdata (onchip_memory_2_s1_readdata),
      .reset_n  (onchip_memory_2_s1_reset_n)
    );

  //reset conditioning register, which is an e_register
  always @(posedge clk or negedge always_one)
    begin
      if (always_one == 0)
        begin
          d1_reset_n_sources <= 0;
          d2_reset_n <= 0;
        end
      else if (1)
        begin
          d1_reset_n_sources <= reset_n_sources;
          d2_reset_n <= d1_reset_n_sources;
        end
    end


  //always one, which is an e_assign
  assign always_one = 1;

  //reset sources mux, which is an e_mux
  assign reset_n_sources = reset_n;



endmodule


//exemplar translate_off



// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE

// AND HERE WILL BE PRESERVED </ALTERA_NOTE>


// If user logic components use Altsync_Ram with convert_hex2ver.dll,
// set USE_convert_hex2ver in the user comments section above

`ifdef USE_convert_hex2ver
`else
`define NO_PLI 1
`endif

`include "cpu.v"
`include "cpu0.v"
`include "cpu1.v"
`include "onchip_memory_0.v"
`include "onchip_memory_1.v"
`include "onchip_memory_2.v"

`timescale 1ns / 100ps

module test_bench ;


  reg              clk;
  wire    [  3: 0] cpu0_instruction_master_byteenable;
  wire    [  3: 0] cpu1_instruction_master_byteenable;
  reg              reset_n;


// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
//  add your signals and additional architecture here
// AND HERE WILL BE PRESERVED </ALTERA_NOTE>

  n105_cluster DUT
    (
      .clk     (clk),
      .reset_n (reset_n)
    );

  initial
    clk = 1'b0;
  always
    #10 clk <= ~clk;
  
  initial 
    begin
      reset_n <= 0;
      #200 reset_n <= 1;
    end


endmodule


//exemplar translate_on