import java.awt.event.*;

class KeyboardPlayerController extends PlayerController {
	KeyboardPlayerListener listener;

	KeyboardPlayerController(int left, int right, int jump) {
		listener = new KeyboardPlayerListener(left, right, jump);
	}

	/***********************************************************************/

	void assignToPlayer(Player p) {
		super.assignToPlayer(p);
		player.side.game.addKeyListener(listener);
	}

	void removeFromPlayer() {
		player.side.game.removeKeyListener(listener);
		super.removeFromPlayer();
	}

	/***********************************************************************/

	class KeyboardPlayerListener extends KeyAdapter {
		int left;
		int right;
		int jump;

		KeyboardPlayerListener(int left, int right, int jump) {
			this.left = left;
			this.right = right;
			this.jump = jump;
		}

		public void keyPressed(KeyEvent e) {
			int code;
			code = e.getKeyCode();
			if (code == left) {
				player.startMoveLeft();
			} else if (code == right) {
				player.startMoveRight();
			} else if (code == jump) {
				player.startJump();
			}
		}

		public void keyReleased(KeyEvent e) {
			int code;
			code = e.getKeyCode();
			if (code == left) {
				player.stopMoveLeft();
			} else if (code == right) {
				player.stopMoveRight();
			}
		}
	}
}
