import table.DuplicateException;
import table.MissingException;
import table.Table;

class TryTable extends Table {
	TryTable(int size) {
		super(size);
	}

	void tryRetrieve(String key) {
		try {
			System.out.println(
				"Successfully retrieved (" + key + ", " + retrieve(key) + ")");
		} catch (MissingException e) {
			System.out.println("Failed: " + e.getMessage());
		}
	}

	void tryStore(String key, String value) {
		try {
			store(key, value);
			System.out.println(
				"Successfully stored (" + key + ", " + value + ")");
		} catch (DuplicateException e) {
			System.out.println("Failed: " + e.getMessage());
		}
	}
}
