// An example class representing complex numbers using a pair of two floating
// point fields. 

class Complex {

	private float real, imaginary;

	Complex(float real) {
		this.real = real;
		this.imaginary = 0.0f;
	}

	Complex(float real, float imaginary) {
		this.real = real;
		this.imaginary = imaginary;
	}

	Complex add(Complex c) {
		return new Complex(this.real + c.real, this.imaginary + c.imaginary);
	}

	Complex multiply(Complex c) {
		return new Complex(
			this.real * c.real - this.imaginary * c.imaginary,
			this.real * c.imaginary + this.imaginary * c.real);
	}

	public String toString() {
		return "(" + this.real + ", " + this.imaginary + ")";
	}
}