/*
 * This is a revised example of "BufferExample" which shows how,
 * using these definition for class "Mutex" and class "CondVar" we can
 * associate multiple condition variables with a single mutex -- this
 * is something that is not ordinarily possible with the basic
 * facilities in Java.
 *
 * The only difference is between the class "Buffer2" and the class
 * "Buffer" -- note that the new definition creates two instances of
 * "CondVar", cv_empty and cv_full.  Threads wait on the condition
 * variable cv_empty when they find the buffer is empty and want to
 * do a "get" operation on it.  They wait on the condition variable 
 * cv_full when they find the buffer is full and want to do a "put"
 * operation on it.
 *
 * Note how the code follows the same basic design as the N-slot
 * buffer example from the slides: now that there are two separate
 * condition variables, one for each different reason that a thread
 * may wish to wait, we can use "CVNotify" rather than needing
 * "CVNotifyAll".
 */

public class BufferExample2 {
	public static void main(String[] args) {
		Buffer b = new BufferMultipleCondvars();
		Thread c = new Consumer(b);
		c.start();
		try {
			for (int i = 1; i <= 7; i++)
				b.put(i);
		} catch (InterruptedException e) {
			System.out.println("Producer interrupted!");
		}
		c.interrupt();

		try {
			c.join();
		} catch (InterruptedException e) {
			System.out.println("Interrupted while waiting for consumer");
		}
	}
}
