class Integer extends Number implements Sortable {
	int i;

	public Integer(int i) {
		this.i = i;
	}

	public Number add(Number n) {
		return n instanceof Integer
			? (Number) new Integer(i + ((Integer) n).i)
			: (Number) new Real(i + ((Real) n).r);
	}

	public int compare(Sortable s) throws IncompatibleTypeException {
		if (s instanceof Integer)
			return i - ((Integer) s).i;
		else if (s instanceof Real)
			return i - ((Real) s).r > 0 ? +1 : -1;
		else
			throw new IncompatibleTypeException(this, s);
	}

	public String toString() {
		return i + ": Integer";
	}
}
