package tlh20.rmi;

import java.net.*;
import java.rmi.*;
import java.rmi.server.*;

public class PhoneticServer extends UnicastRemoteObject implements Phonetic {

  public static void main (String [] args) {
    try {
      System.setSecurityManager (new RMISecurityManager ());
      PhoneticServer s = new PhoneticServer ();
      Naming.rebind (Phonetic.URL + Phonetic.NAME, s);
      System.out.println (Phonetic.NAME + " server running");
    }
    catch (Exception e) {
      System.out.println ("Exception: " + e);
    };
  }

  public PhoneticServer () throws RemoteException {
  //  super ();
  }

  public String [] spell (String s) throws RemoteException {
    return spell (s, false);
  }

  private final static String [] [] WORDS = {
    {"alfa", "aesthetic"},
    {"bravo", "bdellometer"},
    {"charlie", "ctenoid"},
    {"delta", "djibbah"},
    {"echo", "ewe"},
    {"foxtrot", "fnese"},
    {"golf", "gnome"},
    {"hotel", "heir"},
    {"India", "iero"},
    {"Juliet", "Jugoslavia"},
    {"kilo", "know"},
    {"Lima", "pounds, shillings and pence"},
    {"Mike", "mnemonic"},
    {"November", "Nzima"},
    {"Oscar", "oesophagus"},
    {"papa", "pneumonia"},
    {"Quebec", "Qatar"},
    {"Romeo", "'rithmetic"},
    {"sierra", "sdeath"},
    {"tango", "tsar"},
    {"uniform", "Uigur"},
    {"victor", "veldt"},
    {"whiskey", "write"},
    {"x-ray", "xylophone"},
    {"yankee", "yggdrasil"},
    {"zulu", "zucchetto"}
  };

  public String [] spell (String s, boolean silly) throws RemoteException {
    System.out.println ("Spelling '" + s +"'");
    String source = s.toUpperCase ();
    int length = s.length ();
    String [] reply = new String [length];
    for (int i = 0; i < length; i++) {
      try {
	int w = (int) source.charAt (i) - (int) 'A';
	reply [i] = source.substring (i, i+1) 
	            + " as in " + WORDS [w] [silly ? 1 : 0];
      }
      catch (ArrayIndexOutOfBoundsException e) {reply [i] = "?";}
      catch (StringIndexOutOfBoundsException e) {reply [i] = "?";};
    };
    return reply;
  }

}
