There
are
times
when
the
success
of
a
particular
film
depends
entirely
on
one
actor
's
effort
.

Often
a
single
performance
can
turn
what
might
have
been
a
rather
mediocre
movie
into
something
worthwhile
.

When
one
of
these
comes
along
,
I
usually
try
to
think
about
how
many
other
people
put
work
into
the
movie
,
that
there
is
no
way
one
person
could
possible
carry
the
entire
project
on
his
shoulders
.

But
sometimes
there
is
simply
no
other
explanation
,
and
such
is
the
case
with
``
The
Hurricane
.
''

This
biopic
about
falsely
convicted
boxer
Rubin
``
Hurricane
''
Carter
would
normally
be
called
``
Norman
Jewison
's
`
The
Hurricane
,
'
''
as
per
the
tradition
of
referring
to
a
film
``
belonging
''
to
a
director
.

But
though
he
does
decent
work
,
Jewison
can
not
claim
ownership
of
``
The
Hurricane
,
''
because
there
is
one
reason
this
film
works
at
all
,
and
his
name
is
Denzel
Washington
.

Washington
plays
Carter
,
a
boxer
who
in
1967
was
convicted
of
a
late-night
shooting
in
a
bar
.

Jailed
foryears
,
he
maintained
that
he
had
never
committed
the
crimes
,
but
remained
in
jail
after
a
second
trial
and
countless
appeals
.

The
situation
changed
when
a
group
of
Canadians
moved
to
Washington
and
worked
on
freeing
Carter
.

Through
the
efforts
of
that
group
and
Carter
's
lawyers
,
he
was
eventually
freed
when
their
case
was
heard
in
federal
court
and
the
judge
ruled
that
Rubin
Carter
had
been
unfairly
convicted
.

The
film
details
Carter
's
childhood
,
which
had
him
in
and
out
of
jail
because
of
the
efforts
of
a
racist
cop
-LRB-
Dan
Hedaya
-RRB-
.

When
he
finally
got
out
of
prison
for
good
,
Carter
became
a
rising
star
as
a
middleweight
pro
boxer
,
seemingly
having
his
career
on
track
,
until
the
police
framed
him
for
multiple
homicide
.

Despite
the
efforts
of
political
activists
and
celebrities
,
he
remained
imprisoned
.

Flash
forward
to
1983
,
when
Lesra
-LRB-
Vicellous
Reon
Shannon
-RRB-
a
young
African-American
boy
,
living
with
a
group
of
Canadian
tutors
,
reads
the
book
Carter
wrote
while
in
prison
.

The
book
,
entitled
``
The
Sixteenth
Round
,
''
opens
young
Lesra
's
eyes
to
the
injustice
that
was
Carter
's
life
,
and
he
vows
to
help
free
the
incarcerated
boxer
.

Lesra
convinces
his
Canadian
friends
-LRB-
Deborah
Unger
,
Liev
Schreiber
,
John
Hannah
-RRB-
to
work
with
him
towards
his
goal
.

``
The
Hurricane
''
leans
on
Denzel
Washington
.

He
must
carry
virtually
every
scene
by
sheer
force
of
will
,
and
he
does
so
brilliantly
.

It
's
probably
accurate
to
say
that
Washington
does
not
embody
Rubin
Carter
,
because
he
plays
a
character
far
stronger
and
nobler
than
any
real
person
could
hope
to
be
.

It
would
perhaps
be
more
accurate
to
say
that
Washington
embodies
the
character
of
Rubin
Carter
--
a
fictional
personality
invented
solely
for
the
film
.

The
actor
's
work
is
masterful
;
Washington
throws
himself
into
every
moment
,
refusing
to
keep
the
audience
at
arm
's
length
.

We
feel
everything
he
feels
:
the
humiliation
of
having
to
return
to
prison
after
fighting
so
hard
to
make
something
of
his
life
,
the
pain
of
having
to
order
his
wife
to
give
up
the
fight
,
and
the
utter
despair
he
feels
when
coming
to
the
conclusion
that
all
hope
is
lost
.

Washington
's
is
a
performance
of
weight
and
emotional
depth
.

He
does
n't
merely
play
angry
,
happy
,
or
sad
;
he
feels
it
at
the
deepest
level
.

His
work
is
masterful
,
and
for
half
of
this
film
I
realized
that
the
scene
I
was
watching
would
not
have
been
nearly
as
affecting
as
it
was
if
it
had
been
in
the
hands
of
another
actor
.

Norman
Jewison
directs
the
film
,
doing
a
reasonably
good
job
of
pacing
and
shot
selection
.

``
The
Hurricane
''
moves
quickly
,
with
no
scene
drawn
out
much
further
than
necessary
and
the
narrative
galloping
along
nicely
.

Jewison
handles
his
multiple
flashbacks
well
;
the
audience
is
always
aware
of
just
what
the
time
and
place
of
each
scene
is
,
and
nothing
is
terribly
confusing
.

His
boxing
scenes
,
constructed
with
clear
inspiration
from
``
Raging
Bull
,
''
get
inside
the
action
very
well
,
and
they
are
believable
as
real
sports
footage
.

Jewison
puts
together
a
particularly
nice
scene
by
utilizing
a
pretty
cool
trick
:
Carter
is
sent
to
solitary
confinement
fordays
when
he
refuses
to
wear
a
prison
uniform
,
and
Jewison
,
assisted
by
some
wonderful
acting
from
a
game
Washington
,
shows
how
Carter
gradually
starts
to
lose
his
mind
during
the
constant
solitude
,
and
eventually
we
get
three
Rubin
Carters
arguing
with
each
other
in
one
cell
.

Jewison
's
best
achievement
in
``
The
Hurricane
''
is
succeeding
at
showing
how
Carter
becomes
an
embittered
man
during
his
hard-knock
life
,
and
how
he
is
able
to
break
out
of
that
bitterness
and
learn
to
trust
people
again
.

Sadly
,
though
,
the
film
's
chief
failures
lie
with
the
screenplay
,
as
with
most
of
the
good-but-not-great
efforts
to
round
the
pike
this
winter
.

There
is
much
to
interest
a
viewer
in
``
The
Hurricane
,
''
but
it
seems
that
every
time
the
film
gets
a
chance
to
take
the
most
clichéd
route
possible
,
it
does
.

Take
a
look
at
the
supporting
characters
,
for
example
,
who
are
drawn
up
as
either
entirely
good
or
entirely
evil
.

Carter
and
Lesra
-LRB-
played
nicely
by
Shannon
,
who
deserves
credit
-RRB-
are
the
only
real
people
here
;
everyone
else
is
a
stereotype
.

The
Canadians
are
good
.

The
cops
are
bad
.

The
Canadians
spend
most
of
their
time
dolefully
grinning
at
each
other
in
their
lovey-dovey
commune
-LRB-
and
it
is
a
commune
,
despite
the
film
's
failure
to
make
that
clear
-RRB-
,
while
every
racist
cop
-LRB-
especially
Dan
Hedaya
's
-RRB-
melts
in
out
of
the
shadows
and
glowers
at
every
black
person
that
enters
the
room
.

Much
of
the
dialogue
comes
off
as
rather
hokey
-LRB-
``
Hate
put
me
in
prison
.
''

Love
's
gon
na
bust
me
out
.
''
-RRB-

,
and
the
big
courtroom
climax
during
which
everyone
gets
to
make
an
impassioned
speech
could
have
been
lifted
from
a
made-for-TV
Lifetime
special
.
''

It
's
too
bad
.

The
cast
is
game
,
the
director
does
his
job
,
and
the
subject
matter
is
interesting
,
but
the
script
takes
the
safer
,
slightly
more
boring
route
far
too
often
.

I
wanted
a
real
reason
for
the
cop
to
hold
a
grudge
against
Carter
other
than
``
he
's
a
racist
pig
.
''

I
wanted
more
evidence
that
these
Canadians
are
real
people
with
faults
and
virtues
instead
of
a
bunch
of
saintly
crusaders
looking
for
justice
.

In
short
,
I
wanted
to
see
the
film
through
a
less
distorted
lens
.

Criticism
has
been
levied
against
the
liberties
``
The
Hurricane
''
takes
with
the
truth
of
what
really
happened
to
Carter
,
and
much
of
it
is
deserved
.

For
example
,
the
film
gives
us
a
boxing
scene
showing
Carter
pummeling
defending
champ
Joey
Giardello
,
only
to
be
screwed
by
the
judges
,
who
ruled
Giardello
the
winner
.

Most
accounts
of
the
fight
,
however
,
have
Carter
losing
fairly
.

Furthermore
,
much
of
Carter
's
criminal
past
is
conveniently
left
out
of
the
film
,
and
just
why
he
was
convicted
again
in
his
second
trial
is
never
really
explained
.

Of
course
,
``
The
Hurricane
''
works
mainly
as
a
fable
,
so
digressions
from
the
truth
can
be
excused
at
least
partially
,
but
even
dismissing
such
issues
do
n't
remove
one
fact
:
``
The
Hurricane
''
is
a
highly
flawed
film
.

Only
one
actor
could
have
made
a
schmaltzy
,
predictable
picture
like
this
work
as
well
as
it
does
,
and
it
's
a
good
thing
``
The
Hurricane
''
has
that
actor
.

Carter
has
been
quoted
as
saying
,
``
Denzel
Washington
is
making
me
look
good
,
''
but
he
's
not
the
only
one
.

Washington
makes
this
film
look
good
.

Denzel
Washington
's
``
The
Hurricane
.
''

Sounds
pretty
good
to
me
.

