# Copyright (c) 2016, Robert Eady
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this
#    list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# TCL File Generated by Component Editor 16.0
# Thu Aug 25 18:22:03 BST 2016
# DO NOT MODIFY


#
# clarvi "clarvi" v1.0
#  2016.08.25.18:22:03
#
#

#
# request TCL package from ACDS 16.0
#
package require -exact qsys 16.0


#
# module clarvi
#
set_module_property DESCRIPTION ""
set_module_property NAME clarvi
set_module_property VERSION 1.0
set_module_property INTERNAL false
set_module_property OPAQUE_ADDRESS_MAP true
set_module_property AUTHOR ""
set_module_property DISPLAY_NAME clarvi
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property REPORT_TO_TALKBACK false
set_module_property ALLOW_GREYBOX_GENERATION false
set_module_property REPORT_HIERARCHY false


#
# file sets
#
add_fileset QUARTUS_SYNTH QUARTUS_SYNTH "" ""
set_fileset_property QUARTUS_SYNTH TOP_LEVEL clarvi_avalon
set_fileset_property QUARTUS_SYNTH ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property QUARTUS_SYNTH ENABLE_FILE_OVERWRITE_MODE false
add_fileset_file clarvi_avalon.sv SYSTEM_VERILOG PATH clarvi/clarvi_avalon.sv TOP_LEVEL_FILE
add_fileset_file clarvi.sv SYSTEM_VERILOG PATH clarvi/clarvi.sv
add_fileset_file riscv.svh SYSTEM_VERILOG_INCLUDE PATH clarvi/riscv.svh


#
# parameters
#
add_parameter DATA_ADDR_WIDTH INTEGER 14
set_parameter_property DATA_ADDR_WIDTH DEFAULT_VALUE 14
set_parameter_property DATA_ADDR_WIDTH DISPLAY_NAME DATA_ADDR_WIDTH
set_parameter_property DATA_ADDR_WIDTH TYPE INTEGER
set_parameter_property DATA_ADDR_WIDTH UNITS None
set_parameter_property DATA_ADDR_WIDTH ALLOWED_RANGES -2147483648:2147483647
set_parameter_property DATA_ADDR_WIDTH HDL_PARAMETER true
add_parameter INSTR_ADDR_WIDTH INTEGER 14
set_parameter_property INSTR_ADDR_WIDTH DEFAULT_VALUE 14
set_parameter_property INSTR_ADDR_WIDTH DISPLAY_NAME INSTR_ADDR_WIDTH
set_parameter_property INSTR_ADDR_WIDTH TYPE INTEGER
set_parameter_property INSTR_ADDR_WIDTH UNITS None
set_parameter_property INSTR_ADDR_WIDTH ALLOWED_RANGES -2147483648:2147483647
set_parameter_property INSTR_ADDR_WIDTH HDL_PARAMETER true
add_parameter INITIAL_PC INTEGER 0
set_parameter_property INITIAL_PC DEFAULT_VALUE 0
set_parameter_property INITIAL_PC DISPLAY_NAME INITIAL_PC
set_parameter_property INITIAL_PC TYPE INTEGER
set_parameter_property INITIAL_PC UNITS None
set_parameter_property INITIAL_PC ALLOWED_RANGES -2147483648:2147483647
set_parameter_property INITIAL_PC HDL_PARAMETER true
add_parameter DEFAULT_TRAP_VECTOR INTEGER 0
set_parameter_property DEFAULT_TRAP_VECTOR DEFAULT_VALUE 0
set_parameter_property DEFAULT_TRAP_VECTOR DISPLAY_NAME DEFAULT_TRAP_VECTOR
set_parameter_property DEFAULT_TRAP_VECTOR TYPE INTEGER
set_parameter_property DEFAULT_TRAP_VECTOR UNITS None
set_parameter_property DEFAULT_TRAP_VECTOR ALLOWED_RANGES -2147483648:2147483647
set_parameter_property DEFAULT_TRAP_VECTOR HDL_PARAMETER true


#
# display items
#


#
# connection point reset
#
add_interface reset reset end
set_interface_property reset associatedClock clock
set_interface_property reset synchronousEdges DEASSERT
set_interface_property reset ENABLED true
set_interface_property reset EXPORT_OF ""
set_interface_property reset PORT_NAME_MAP ""
set_interface_property reset CMSIS_SVD_VARIABLES ""
set_interface_property reset SVD_ADDRESS_GROUP ""

add_interface_port reset reset reset Input 1


#
# connection point interrupt_receiver_0
#
add_interface interrupt_receiver_0 interrupt start
set_interface_property interrupt_receiver_0 associatedAddressablePoint ""
set_interface_property interrupt_receiver_0 irqScheme INDIVIDUAL_REQUESTS
set_interface_property interrupt_receiver_0 ENABLED true
set_interface_property interrupt_receiver_0 EXPORT_OF ""
set_interface_property interrupt_receiver_0 PORT_NAME_MAP ""
set_interface_property interrupt_receiver_0 CMSIS_SVD_VARIABLES ""
set_interface_property interrupt_receiver_0 SVD_ADDRESS_GROUP ""

add_interface_port interrupt_receiver_0 inr_irq irq Input 1


#
# connection point main
#
add_interface main avalon start
set_interface_property main addressUnits WORDS
set_interface_property main associatedClock clock
set_interface_property main associatedReset reset
set_interface_property main bitsPerSymbol 8
set_interface_property main burstOnBurstBoundariesOnly false
set_interface_property main burstcountUnits WORDS
set_interface_property main doStreamReads false
set_interface_property main doStreamWrites false
set_interface_property main holdTime 0
set_interface_property main linewrapBursts false
set_interface_property main maximumPendingReadTransactions 0
set_interface_property main maximumPendingWriteTransactions 0
set_interface_property main readLatency 0
set_interface_property main readWaitTime 0
set_interface_property main setupTime 0
set_interface_property main timingUnits Cycles
set_interface_property main writeWaitTime 0
set_interface_property main ENABLED true
set_interface_property main EXPORT_OF ""
set_interface_property main PORT_NAME_MAP ""
set_interface_property main CMSIS_SVD_VARIABLES ""
set_interface_property main SVD_ADDRESS_GROUP ""

add_interface_port main avm_main_address address Output DATA_ADDR_WIDTH
add_interface_port main avm_main_byteenable byteenable Output 4
add_interface_port main avm_main_read read Output 1
add_interface_port main avm_main_readdata readdata Input 32
add_interface_port main avm_main_write write Output 1
add_interface_port main avm_main_writedata writedata Output 32
add_interface_port main avm_main_waitrequest waitrequest Input 1
add_interface_port main avm_main_readdatavalid readdatavalid Input 1


#
# connection point instr
#
add_interface instr avalon start
set_interface_property instr addressUnits WORDS
set_interface_property instr associatedClock clock
set_interface_property instr associatedReset reset
set_interface_property instr bitsPerSymbol 8
set_interface_property instr burstOnBurstBoundariesOnly false
set_interface_property instr burstcountUnits WORDS
set_interface_property instr doStreamReads false
set_interface_property instr doStreamWrites false
set_interface_property instr holdTime 0
set_interface_property instr linewrapBursts false
set_interface_property instr maximumPendingReadTransactions 0
set_interface_property instr maximumPendingWriteTransactions 0
set_interface_property instr readLatency 0
set_interface_property instr readWaitTime 0
set_interface_property instr setupTime 0
set_interface_property instr timingUnits Cycles
set_interface_property instr writeWaitTime 0
set_interface_property instr ENABLED true
set_interface_property instr EXPORT_OF ""
set_interface_property instr PORT_NAME_MAP ""
set_interface_property instr CMSIS_SVD_VARIABLES ""
set_interface_property instr SVD_ADDRESS_GROUP ""

add_interface_port instr avm_instr_address address Output INSTR_ADDR_WIDTH
add_interface_port instr avm_instr_read read Output 1
add_interface_port instr avm_instr_readdata readdata Input 32
add_interface_port instr avm_instr_waitrequest waitrequest Input 1
add_interface_port instr avm_instr_readdatavalid readdatavalid Input 1


#
# connection point clock
#
add_interface clock clock end
set_interface_property clock clockRate 0
set_interface_property clock ENABLED true
set_interface_property clock EXPORT_OF ""
set_interface_property clock PORT_NAME_MAP ""
set_interface_property clock CMSIS_SVD_VARIABLES ""
set_interface_property clock SVD_ADDRESS_GROUP ""

add_interface_port clock clock clk Input 1


#
# connection point debug
#
add_interface debug conduit end
set_interface_property debug associatedClock ""
set_interface_property debug associatedReset ""
set_interface_property debug ENABLED true
set_interface_property debug EXPORT_OF ""
set_interface_property debug PORT_NAME_MAP ""
set_interface_property debug CMSIS_SVD_VARIABLES ""
set_interface_property debug SVD_ADDRESS_GROUP ""

add_interface_port debug debug_register28 register28 Output 32
add_interface_port debug debug_scratch scratch Output 32
add_interface_port debug debug_pc pc Output 32
