## What's here

This directory contains the following four categories of files:

 * Incomplete code, to be completed by following the instructions in
   the accompanying exercise sheet.

   * `char_test.ml`

     Answers to question 1 go in here.

   * `nfa_staged.ml`

     Answers to question 2 go in here.

 * Supplied library code.  You should not need to change this.

   - `nfa.ml`
      A naive implementation of an NFA type and interpreter

   - `regex.mli`, `regex.ml`:
      Regular expression combinators, along with a translation to NFAs.

 * Test code:

   - `top.ml`

      Load this file into the metaocaml top-level to run code
      interactively:

      ```
      $ metaocaml
      BER MetaOCaml toplevel, version N 104
              OCaml version 4.04.0

      # #use "top.ml";;
      ```
       
   - `tests.ml`
      Tests for the staged and unstaged regex/NFA code.  Type

      ```
      make test
      ```

   - `benchmark.ml`

      Benchmarks that compare the ocaml-re library with the staged and
      unstaged regex/NFA implementations in this directory.  Type

      ```
      make bench
      ```

      The tests for the staged version are initially disabled;
      uncomment the code labeled 'TODO' to enable them.

 * Build system files, used for compiling and linking the code:
   `Makefile` `ex3.mllib`, `myocamlbuild.ml`, `_tags`

## Getting started

The following instructions set up the build environment:


   ```
   opam remote add advanced-fp https://github.com/ocamllabs/advanced-fp-repo.git
   opam switch 4.04.0+BER
   eval $(opam config env)
   opam install letrec re core_bench
   ```
