/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.databases.moviedb.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;
import uk.ac.cam.cl.databases.moviedb.model.Certificate;
import uk.ac.cam.cl.databases.moviedb.model.CreditActor;
import uk.ac.cam.cl.databases.moviedb.model.CreditPerson;
import uk.ac.cam.cl.databases.moviedb.model.CreditWriter;
import uk.ac.cam.cl.databases.moviedb.model.Language;
import uk.ac.cam.cl.databases.moviedb.model.Location;
import uk.ac.cam.cl.databases.moviedb.model.ReleaseDate;

public class Movie {
    private int id;
    private String title;
    private int year;
    private List<CreditActor> actors;
    private List<CreditPerson> cinematographers;
    private List<CreditPerson> composers;
    private List<CreditPerson> costumeDesigners;
    private List<CreditPerson> directors;
    private List<CreditPerson> editors;
    private List<CreditPerson> producers;
    private List<CreditPerson> productionDesigners;
    private List<CreditWriter> writers;
    private List<Certificate> certificates;
    private List<String> genres;
    private List<String> keywords;
    private List<Language> languages;
    private List<Location> locations;
    private Map<String, List<ReleaseDate>> releaseDates;
    static final Gson JSON_CODEC = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public static Movie fromJson(String json) {
        return (Movie)JSON_CODEC.fromJson(json, Movie.class);
    }

    public String toString() {
        return JSON_CODEC.toJson((Object)this);
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public int getYear() {
        return this.year;
    }

    public List<CreditActor> getActors() {
        return this.actors;
    }

    public List<CreditPerson> getCinematographers() {
        return this.cinematographers;
    }

    public List<CreditPerson> getComposers() {
        return this.composers;
    }

    public List<CreditPerson> getCostumeDesigners() {
        return this.costumeDesigners;
    }

    public List<CreditPerson> getDirectors() {
        return this.directors;
    }

    public List<CreditPerson> getEditors() {
        return this.editors;
    }

    public List<CreditPerson> getProducers() {
        return this.producers;
    }

    public List<CreditPerson> getProductionDesigners() {
        return this.productionDesigners;
    }

    public List<CreditWriter> getWriters() {
        return this.writers;
    }

    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    public List<String> getGenres() {
        return this.genres;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Map<String, List<ReleaseDate>> getReleaseDates() {
        return this.releaseDates;
    }
}

