/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicaStateException;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.RepGroupProtocol;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.util.DbPing;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationGroupAdmin {
    private final String groupName;
    private final Set<InetSocketAddress> helperSockets;
    private final Protocol electionsProtocol;
    private final RepGroupProtocol groupProtocol;
    private final Logger logger;
    private final Formatter formatter;

    public ReplicationGroupAdmin(String groupName, Set<InetSocketAddress> helperSockets) {
        this.groupName = groupName;
        this.helperSockets = helperSockets;
        this.electionsProtocol = new Protocol(TimebasedProposalGenerator.getParser(), MasterValue.getParser(), groupName, NameIdPair.NOCHECK, null);
        this.groupProtocol = new RepGroupProtocol(groupName, NameIdPair.NOCHECK, null);
        this.logger = LoggerUtils.getLoggerFixedPrefix(this.getClass(), NameIdPair.NOCHECK.toString());
        this.formatter = new ReplicationFormatter(NameIdPair.NOCHECK);
    }

    public Set<InetSocketAddress> getHelperSockets() {
        return this.helperSockets;
    }

    public String getGroupName() {
        return this.groupName;
    }

    private InetSocketAddress getMasterSocket() throws UnknownMasterException, EnvironmentFailureException {
        MasterValue masterValue = Learner.findMaster(this.electionsProtocol, this.helperSockets, this.logger, null, this.formatter);
        return new InetSocketAddress(masterValue.getHostName(), masterValue.getPort());
    }

    public String getMasterNodeName() throws UnknownMasterException, EnvironmentFailureException {
        MasterValue masterValue = Learner.findMaster(this.electionsProtocol, this.helperSockets, this.logger, null, this.formatter);
        return masterValue.getNodeName();
    }

    public ReplicationNode ensureMonitor(RepNodeImpl monitor) throws UnknownMasterException, EnvironmentFailureException {
        if (monitor.getType() != NodeType.MONITOR) {
            throw EnvironmentFailureException.unexpectedState("Node type must be Monitor not: " + (Object)((Object)monitor.getType()));
        }
        MasterValue masterValue = Learner.findMaster(this.electionsProtocol, this.helperSockets, this.logger, null, this.formatter);
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        RepGroupProtocol.EnsureOK okResp = (RepGroupProtocol.EnsureOK)this.doMessageExchange(repGroupProtocol.new RepGroupProtocol.EnsureNode(monitor), RepGroupProtocol.EnsureOK.class);
        monitor.getNameIdPair().update(okResp.getNameIdPair());
        return new RepNodeImpl(new NameIdPair(masterValue.getNodeName()), NodeType.ELECTABLE, masterValue.getHostName(), masterValue.getPort());
    }

    public void removeMember(String nodeName) throws UnknownMasterException, MemberNotFoundException, MasterStateException, EnvironmentFailureException {
        String masterErrorMessage = "Cannot remove an active master";
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        RepGroupProtocol.RemoveMember request = repGroupProtocol.new RepGroupProtocol.RemoveMember(nodeName);
        this.checkMember(nodeName, "Cannot remove an active master", false);
        this.doMessageExchange(request, TextProtocol.OK.class);
    }

    public ReplicationGroup getGroup() throws UnknownMasterException, EnvironmentFailureException {
        RepGroupProtocol.GroupResponse resp = (RepGroupProtocol.GroupResponse)this.doMessageExchange(this.groupProtocol.new RepGroupProtocol.GroupRequest(), RepGroupProtocol.GroupResponse.class);
        return new ReplicationGroup(resp.getGroup());
    }

    public NodeState getNodeState(ReplicationNode repNode, int socketConnectTimeout) throws IOException, ServiceDispatcher.ServiceConnectFailedException {
        DbPing ping = new DbPing(repNode, this.groupName, socketConnectTimeout);
        return ping.getNodeState();
    }

    public void updateAddress(String nodeName, String newHostName, int newPort) throws EnvironmentFailureException, MasterStateException, MemberNotFoundException, ReplicaStateException, UnknownMasterException {
        String masterErrorMessage = "Can't update address for the current master.";
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        RepGroupProtocol.UpdateAddress request = repGroupProtocol.new RepGroupProtocol.UpdateAddress(nodeName, newHostName, newPort);
        this.checkMember(nodeName, "Can't update address for the current master.", false);
        this.doMessageExchange(request, TextProtocol.OK.class);
    }

    public String transferMaster(Set<String> nodeNames, int timeout, TimeUnit timeUnit, boolean force) throws MasterTransferFailureException, UnknownMasterException {
        for (String node : nodeNames) {
            this.checkMember(node, null, true);
        }
        String nodeNameList = this.commaJoin(nodeNames);
        long timeoutMillis = timeUnit.toMillis(timeout);
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        RepGroupProtocol.TransferMaster transferMaster = repGroupProtocol.new RepGroupProtocol.TransferMaster(nodeNameList, timeoutMillis, force);
        RepGroupProtocol.TransferOK result = (RepGroupProtocol.TransferOK)this.doMessageExchange(transferMaster, RepGroupProtocol.TransferOK.class);
        return result.getWinner();
    }

    private String commaJoin(Set<String> words) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String w : words) {
            if (!first) {
                sb.append(',');
            }
            sb.append(w);
            first = false;
        }
        return sb.toString();
    }

    private void checkMember(String nodeName, String masterErrorMessage, boolean electableOnly) throws MasterStateException, MemberNotFoundException {
        InetSocketAddress masterAddress;
        ReplicationGroup group = this.getGroup();
        RepNodeImpl node = (RepNodeImpl)group.getMember(nodeName);
        if (node == null) {
            throw new MemberNotFoundException("Node: " + nodeName + " is not a member of the " + "group: " + this.groupName);
        }
        if (electableOnly && node.getType() != NodeType.ELECTABLE) {
            throw new IllegalArgumentException("Node: " + nodeName + " must have node type" + " ELECTABLE,  was " + (Object)((Object)node.getType()));
        }
        if (node.isRemoved() && node.isQuorumAck()) {
            throw new MemberNotFoundException("Node: " + nodeName + " is not currently a member " + "of the group: " + this.groupName + ", it has been removed.");
        }
        if (masterErrorMessage != null && (masterAddress = this.getMasterSocket()).equals(node.getSocketAddress())) {
            throw new MasterStateException(masterErrorMessage);
        }
    }

    private TextProtocol.ResponseMessage doMessageExchange(TextProtocol.RequestMessage request, Class<?> respClass) throws EnvironmentFailureException, MasterStateException, MemberNotFoundException, UnknownMasterException {
        InetSocketAddress masterAddress = this.getMasterSocket();
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        TextProtocol.MessageExchange me = new TextProtocol.MessageExchange(repGroupProtocol, masterAddress, "Group", request);
        me.run();
        TextProtocol.ResponseMessage resp = me.getResponseMessage();
        if (resp == null) {
            if (me.getException() != null) {
                throw new UnknownMasterException("Problem communicating with master.", me.getException());
            }
            return null;
        }
        if (respClass == null && resp instanceof RepGroupProtocol.Fail) {
            throw this.getException(resp);
        }
        if (respClass != null && !resp.getClass().getName().equals(respClass.getName())) {
            throw this.getException(resp);
        }
        return resp;
    }

    private DatabaseException getException(TextProtocol.ResponseMessage resp) {
        if (resp == null) {
            return EnvironmentFailureException.unexpectedState("No response to request");
        }
        if (resp instanceof RepGroupProtocol.Fail) {
            RepGroupProtocol.Fail fail = (RepGroupProtocol.Fail)resp;
            switch (fail.getReason()) {
                case MEMBER_NOT_FOUND: {
                    return new MemberNotFoundException(fail.getMessage());
                }
                case IS_MASTER: {
                    return new MasterStateException(fail.getMessage());
                }
                case IS_REPLICA: {
                    return new ReplicaStateException(fail.getMessage());
                }
                case TRANSFER_FAIL: {
                    return new MasterTransferFailureException(fail.getMessage());
                }
            }
            return EnvironmentFailureException.unexpectedState(fail.getMessage());
        }
        if (resp instanceof TextProtocol.ProtocolError) {
            return EnvironmentFailureException.unexpectedState(((TextProtocol.ProtocolError)resp).getMessage());
        }
        return EnvironmentFailureException.unexpectedState("Response not recognized: " + resp);
    }
}

