/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.vlsn.VLSNBucket;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

class GhostBucket
extends VLSNBucket {
    private long firstPossibleLsn;
    private long lastPossibleLsn;

    GhostBucket(VLSN ghostVLSN, long firstPossibleLsn, long lastPossibleLsn) {
        super(DbLsn.getFileNumber(firstPossibleLsn), 0, 1, 1, ghostVLSN);
        this.firstPossibleLsn = firstPossibleLsn;
        this.lastPossibleLsn = lastPossibleLsn;
        this.dirty = true;
    }

    static GhostBucket makeNewInstance(TupleInput ti) {
        VLSN ghostVLSN = new VLSN(ti.readPackedLong());
        long firstLsn = ti.readPackedLong();
        long lastLsn = ti.readPackedLong();
        return new GhostBucket(ghostVLSN, firstLsn, lastLsn);
    }

    boolean isGhost() {
        return true;
    }

    void writeToTupleOutput(TupleOutput to) {
        to.writePackedLong(this.firstVLSN.getSequence());
        to.writePackedLong(this.firstPossibleLsn);
        to.writePackedLong(this.lastPossibleLsn);
    }

    public synchronized long getGTELsn(VLSN vlsn) {
        return this.lastPossibleLsn;
    }

    synchronized long getLTELsn(VLSN vlsn) {
        return this.firstPossibleLsn;
    }

    public synchronized long getLsn(VLSN vlsn) {
        return -1L;
    }

    long getLTEFileNumber() {
        return DbLsn.getFileNumber(this.firstPossibleLsn);
    }

    long getGTEFileNumber() {
        return DbLsn.getFileNumber(this.lastPossibleLsn);
    }

    synchronized boolean put(VLSN vlsn, long lsn) {
        throw EnvironmentFailureException.unexpectedState("Shouldn't be called");
    }

    VLSNBucket removeFromHead(EnvironmentImpl envImpl, VLSN lastDuplicate) {
        throw EnvironmentFailureException.unexpectedState("Shouldn't be called, only used in recovery merging.");
    }

    void removeFromTail(VLSN startOfDelete, long prevLsn) {
        throw EnvironmentFailureException.unexpectedState("Shouldn't be called");
    }

    int getNumOffsets() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<GhostBucket vlsn=");
        sb.append(this.firstVLSN);
        sb.append(" firstLsn=");
        sb.append(DbLsn.getNoFormatString(this.firstPossibleLsn));
        sb.append(" lastLsn=").append(DbLsn.getNoFormatString(this.lastPossibleLsn));
        sb.append("/>");
        return sb.toString();
    }
}

