/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.CleanerLogSummary;
import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.cleaner.FileProcessor;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonRunner;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.ExceptionListenerUser;
import com.sleepycat.je.utilint.FloatStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cleaner
implements DaemonRunner,
EnvConfigObserver,
ExceptionListenerUser {
    static final String CLEAN_IN = "CleanIN:";
    static final String CLEAN_LN = "CleanLN:";
    static final String CLEAN_MIGRATE_LN = "CleanMigrateLN:";
    static final String CLEAN_PENDING_LN = "CleanPendingLN:";
    static final CacheMode UPDATE_GENERATION = CacheMode.UNCHANGED;
    static final boolean DO_CRITICAL_EVICTION = true;
    static final int BACKLOG_ALERT_COUNT = 5;
    static final int BACKLOG_ALERT_FLOOR = 5;
    private final LinkedList<Integer> backlogAlertList = new LinkedList();
    StatGroup stats;
    LongStat nCleanerRuns;
    LongStat nCleanerProbeRuns;
    LongStat nCleanerDeletions;
    LongStat nINsObsolete;
    LongStat nINsCleaned;
    LongStat nINsDead;
    LongStat nINsMigrated;
    LongStat nBINDeltasObsolete;
    LongStat nBINDeltasCleaned;
    LongStat nBINDeltasDead;
    LongStat nBINDeltasMigrated;
    LongStat nLNsObsolete;
    LongStat nLNsCleaned;
    LongStat nLNsDead;
    LongStat nLNsLocked;
    LongStat nLNsMigrated;
    LongStat nLNsMarked;
    LongStat nLNQueueHits;
    LongStat nPendingLNsProcessed;
    LongStat nMarkedLNsProcessed;
    LongStat nToBeCleanedLNsProcessed;
    LongStat nClusterLNsProcessed;
    LongStat nPendingLNsLocked;
    LongStat nEntriesRead;
    LongStat nRepeatIteratorReads;
    LongStat totalLogSize;
    FloatStat lnSizeCorrectionFactor;
    long lockTimeout;
    int readBufferSize;
    int lookAheadCacheSize;
    long nDeadlockRetries;
    boolean expunge;
    boolean clusterResident;
    boolean clusterAll;
    int maxBatchFiles;
    long cleanerBytesInterval;
    boolean trackDetail;
    boolean fetchObsoleteSize;
    boolean lazyMigration;
    int dbCacheClearCount;
    private boolean foregroundProactiveMigration;
    private boolean backgroundProactiveMigration;
    private final boolean rmwFixEnabled;
    int minUtilization;
    int minFileUtilization;
    int minAge;
    private Set<Long> toBeCleanedFiles = Collections.emptySet();
    private Set<Long> lowUtilizationFiles = Collections.emptySet();
    private final String name;
    private final EnvironmentImpl env;
    private final UtilizationProfile profile;
    private final UtilizationTracker tracker;
    private final UtilizationCalculator calculator;
    private final FileSelector fileSelector;
    private FileProcessor[] threads;
    private final List<Long> protectedFileRanges;
    private final Logger logger;
    final AtomicLong totalRuns;
    TestHook fileChosenHook;
    private final AtomicBoolean processPendingReentrancyGuard = new AtomicBoolean(false);

    public Cleaner(EnvironmentImpl env, String name) throws DatabaseException {
        this.env = env;
        this.name = name;
        this.stats = new StatGroup("Cleaning", "Frequency and extent of log file cleaning activity.");
        this.nCleanerRuns = new LongStat(this.stats, CleanerStatDefinition.CLEANER_RUNS);
        this.nCleanerProbeRuns = new LongStat(this.stats, CleanerStatDefinition.CLEANER_PROBE_RUNS);
        this.nCleanerDeletions = new LongStat(this.stats, CleanerStatDefinition.CLEANER_DELETIONS);
        this.nINsObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_OBSOLETE);
        this.nINsCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_CLEANED);
        this.nINsDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_DEAD);
        this.nINsMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_MIGRATED);
        this.nBINDeltasObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_OBSOLETE);
        this.nBINDeltasCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_CLEANED);
        this.nBINDeltasDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_DEAD);
        this.nBINDeltasMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_MIGRATED);
        this.nLNsObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_OBSOLETE);
        this.nLNsCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_CLEANED);
        this.nLNsDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_DEAD);
        this.nLNsLocked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_LOCKED);
        this.nLNsMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_MIGRATED);
        this.nLNsMarked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_MARKED);
        this.nLNQueueHits = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNQUEUE_HITS);
        this.nPendingLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED);
        this.nMarkedLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED);
        this.nToBeCleanedLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED);
        this.nClusterLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED);
        this.nPendingLNsLocked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED);
        this.nEntriesRead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_ENTRIES_READ);
        this.nRepeatIteratorReads = new LongStat(this.stats, CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS);
        this.totalLogSize = new LongStat(this.stats, CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE);
        this.lnSizeCorrectionFactor = new FloatStat(this.stats, CleanerStatDefinition.CLEANER_LN_SIZE_CORRECTION_FACTOR);
        this.tracker = new UtilizationTracker(env, this);
        this.profile = new UtilizationProfile(env, this.tracker);
        this.calculator = new UtilizationCalculator(env, this);
        this.fileSelector = new FileSelector();
        this.threads = new FileProcessor[0];
        this.protectedFileRanges = new LinkedList<Long>();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.totalRuns = new AtomicLong(0L);
        this.trackDetail = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_TRACK_DETAIL);
        this.rmwFixEnabled = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_RMW_FIX);
        this.envConfigUpdate(env.getConfigManager(), null);
        env.addConfigObserver(this);
        env.registerExceptionListenerUser(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.lockTimeout = cm.getDuration(EnvironmentParams.CLEANER_LOCK_TIMEOUT);
        this.readBufferSize = cm.getInt(EnvironmentParams.CLEANER_READ_SIZE);
        if (this.readBufferSize <= 0) {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        this.lookAheadCacheSize = cm.getInt(EnvironmentParams.CLEANER_LOOK_AHEAD_CACHE_SIZE);
        this.foregroundProactiveMigration = cm.getBoolean(EnvironmentParams.CLEANER_FOREGROUND_PROACTIVE_MIGRATION);
        this.backgroundProactiveMigration = cm.getBoolean(EnvironmentParams.CLEANER_BACKGROUND_PROACTIVE_MIGRATION);
        this.nDeadlockRetries = cm.getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
        this.expunge = cm.getBoolean(EnvironmentParams.CLEANER_REMOVE);
        this.clusterResident = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER);
        this.clusterAll = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER_ALL);
        this.maxBatchFiles = cm.getInt(EnvironmentParams.CLEANER_MAX_BATCH_FILES);
        this.dbCacheClearCount = cm.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        if (this.clusterResident && this.clusterAll) {
            throw new IllegalArgumentException("Both " + EnvironmentParams.CLEANER_CLUSTER + " and " + EnvironmentParams.CLEANER_CLUSTER_ALL + " may not be set to true.");
        }
        int nThreads = cm.getInt(EnvironmentParams.CLEANER_THREADS);
        assert (nThreads > 0);
        if (nThreads != this.threads.length) {
            int i;
            for (int i2 = nThreads; i2 < this.threads.length; ++i2) {
                if (this.threads[i2] == null) continue;
                this.threads[i2].shutdown();
                this.threads[i2] = null;
            }
            FileProcessor[] newThreads = new FileProcessor[nThreads];
            for (i = 0; i < nThreads && i < this.threads.length; ++i) {
                newThreads[i] = this.threads[i];
            }
            this.threads = newThreads;
            for (i = 0; i < nThreads; ++i) {
                if (this.threads[i] != null) continue;
                this.threads[i] = new FileProcessor(this.name + '-' + (i + 1), this.env, this, this.profile, this.calculator, this.fileSelector);
            }
        }
        this.cleanerBytesInterval = cm.getLong(EnvironmentParams.CLEANER_BYTES_INTERVAL);
        if (this.cleanerBytesInterval == 0L) {
            this.cleanerBytesInterval = cm.getLong(EnvironmentParams.LOG_FILE_MAX) / 4L;
        }
        this.fetchObsoleteSize = cm.getBoolean(EnvironmentParams.CLEANER_FETCH_OBSOLETE_SIZE);
        this.lazyMigration = cm.getBoolean(EnvironmentParams.CLEANER_LAZY_MIGRATION) && !cm.getBoolean(EnvironmentParams.CHECKPOINTER_HIGH_PRIORITY);
        this.minAge = cm.getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
        this.minFileUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_FILE_UTILIZATION);
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.tracker;
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.profile;
    }

    public UtilizationCalculator getUtilizationCalculator() {
        return this.calculator;
    }

    public FileSelector getFileSelector() {
        return this.fileSelector;
    }

    public boolean getFetchObsoleteSize() {
        return this.fetchObsoleteSize;
    }

    public boolean isRMWFixEnabled() {
        return this.rmwFixEnabled;
    }

    public void setFileChosenHook(TestHook hook) {
        this.fileChosenHook = hook;
    }

    public CleanerLogSummary getLogSummary() {
        return this.calculator.getLogSummary();
    }

    public void setLogSummary(CleanerLogSummary logSummary) {
        this.calculator.setLogSummary(logSummary);
    }

    @Override
    public void runOrPause(boolean run) {
        if (!this.env.isNoLocking()) {
            for (FileProcessor processor : this.threads) {
                if (processor == null) continue;
                processor.runOrPause(run);
            }
        }
    }

    public void wakeup() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.wakeup();
        }
    }

    @Override
    public void requestShutdown() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.requestShutdown();
        }
    }

    @Override
    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].shutdown();
            this.threads[i].clearEnv();
            this.threads[i] = null;
        }
    }

    @Override
    public int getNWakeupRequests() {
        int count = 0;
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            count += thread.getNWakeupRequests();
        }
        return count;
    }

    private boolean areThreadsRunning() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            return thread.isRunning();
        }
        return false;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.setExceptionListener(exceptionListener);
        }
    }

    public int doClean(boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        FileProcessor processor = new FileProcessor("", this.env, this, this.profile, this.calculator, this.fileSelector);
        return processor.doClean(false, cleanMultipleFiles, forceCleaning);
    }

    public StatGroup loadStats(StatsConfig config) {
        if (!config.getFast()) {
            this.totalLogSize.set(this.profile.getTotalLogSize());
        }
        this.lnSizeCorrectionFactor.set(Float.valueOf(this.calculator.getLNSizeCorrectionFactor()));
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        copyStats.addAll(this.fileSelector.loadStats());
        return copyStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteSafeToDeleteFiles() throws DatabaseException {
        FileManager fileManager;
        Object fileNum;
        this.env.checkIfInvalid();
        if (this.env.mayNotWrite()) {
            return;
        }
        SortedSet<Long> safeToDeleteFiles = this.fileSelector.copySafeToDeleteFiles();
        if (safeToDeleteFiles == null) {
            return;
        }
        SortedSet<Long> unprotectedFiles = this.env.getUnprotectedFileSet(safeToDeleteFiles);
        if (unprotectedFiles == null) {
            return;
        }
        if (unprotectedFiles.isEmpty()) {
            LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner has " + safeToDeleteFiles.size() + " files not deleted because they are " + "protected by replication.");
            return;
        }
        Long[] unprotectedFilesArray = unprotectedFiles.toArray(new Long[0]);
        for (int i = unprotectedFilesArray.length - 1; i >= 0; --i) {
            fileNum = unprotectedFilesArray[i];
            VLSN lastVlsn = this.fileSelector.getLastVLSN((Long)fileNum);
            if (lastVlsn == null || lastVlsn.isNull()) continue;
            this.env.vlsnHeadTruncate(lastVlsn, (Long)fileNum);
            break;
        }
        if (!(fileManager = this.env.getFileManager()).lockEnvironment(false, true)) {
            LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner has " + safeToDeleteFiles.size() + " files not deleted because of read-only" + " processes.");
            return;
        }
        try {
            fileNum = this.protectedFileRanges;
            synchronized (fileNum) {
                if (!this.protectedFileRanges.isEmpty()) {
                    unprotectedFiles = unprotectedFiles.headSet(Collections.min(this.protectedFileRanges));
                }
                Iterator iter = unprotectedFiles.iterator();
                while (iter.hasNext()) {
                    boolean deleted;
                    Long fileNum2 = (Long)iter.next();
                    try {
                        deleted = this.expunge ? fileManager.deleteFile(fileNum2) : fileManager.renameFile(fileNum2, ".del");
                    }
                    catch (IOException e) {
                        throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_WRITE, "Unable to delete or rename " + fileNum2, e);
                    }
                    if (deleted) {
                        LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, "Cleaner deleted file 0x" + Long.toHexString(fileNum2));
                        continue;
                    }
                    if (!fileManager.isFileValid(fileNum2)) {
                        LoggerUtils.traceAndLog(this.logger, this.env, Level.SEVERE, "Cleaner deleteSafeToDeleteFiles Log file 0x" + Long.toHexString(fileNum2) + " was previously " + (this.expunge ? "deleted" : "renamed") + ".  State: " + this.fileSelector);
                        continue;
                    }
                    iter.remove();
                    LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner deleteSafeToDeleteFiles Log file 0x" + Long.toHexString(fileNum2) + " could not be " + (this.expunge ? "deleted" : "renamed") + ". This " + "operation will be retried at the next " + "checkpoint. State: " + this.fileSelector);
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            fileManager.releaseExclusiveLock();
            throw throwable;
        }
        fileManager.releaseExclusiveLock();
        this.profile.removePerDbMetadata(unprotectedFiles, this.fileSelector.getCleanedDatabases(unprotectedFiles));
        for (Long fileNum3 : unprotectedFiles) {
            Object var14_15;
            try {
                this.profile.removePerFileMetadata(fileNum3);
                var14_15 = null;
                this.fileSelector.removeDeletedFile(fileNum3, this.env.getMemoryBudget());
            }
            catch (Throwable throwable) {
                var14_15 = null;
                this.fileSelector.removeDeletedFile(fileNum3, this.env.getMemoryBudget());
                throw throwable;
            }
            this.nCleanerDeletions.increment();
        }
        if (safeToDeleteFiles.size() > unprotectedFiles.size()) {
            LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner has " + (safeToDeleteFiles.size() - unprotectedFiles.size()) + " files not deleted because they are protected by DbBackup " + "or replication.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtectedFileRange(long firstProtectedFile) {
        List<Long> list = this.protectedFileRanges;
        synchronized (list) {
            this.protectedFileRanges.add(firstProtectedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProtectedFileRange(long firstProtectedFile) {
        List<Long> list = this.protectedFileRanges;
        synchronized (list) {
            if (!this.protectedFileRanges.remove(firstProtectedFile)) {
                throw EnvironmentFailureException.unexpectedState("File range starting with 0x" + Long.toHexString(firstProtectedFile) + " is not currently protected");
            }
        }
    }

    public FileSelector.CheckpointStartCleanerState getFilesAtCheckpointStart() throws DatabaseException {
        this.processPending();
        return this.fileSelector.getFilesAtCheckpointStart();
    }

    public void updateFilesAtCheckpointEnd(FileSelector.CheckpointStartCleanerState info) throws DatabaseException {
        this.fileSelector.updateFilesAtCheckpointEnd(info);
        this.deleteSafeToDeleteFiles();
    }

    void updateReadOnlyFileCollections() {
        this.lowUtilizationFiles = this.fileSelector.getLowUtilizationFiles();
        Set<Long> oldToBeCleaned = this.toBeCleanedFiles;
        Set<Long> newToBeCleaned = this.fileSelector.getToBeCleanedFiles();
        this.toBeCleanedFiles = newToBeCleaned;
        this.checkBacklogGrowth(oldToBeCleaned.size(), newToBeCleaned.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBacklogGrowth(int oldBacklog, int newBacklog) {
        float newAvg;
        float oldAvg;
        boolean averagesAreValid;
        LinkedList<Integer> linkedList = this.backlogAlertList;
        synchronized (linkedList) {
            averagesAreValid = this.backlogAlertList.size() >= 5;
            oldAvg = Cleaner.getAverage(this.backlogAlertList);
            this.backlogAlertList.addLast(newBacklog);
            while (this.backlogAlertList.size() > 5) {
                this.backlogAlertList.removeFirst();
            }
            newAvg = Cleaner.getAverage(this.backlogAlertList);
        }
        if (newBacklog < 5) {
            return;
        }
        if (newBacklog <= oldBacklog) {
            return;
        }
        if (!averagesAreValid || newAvg <= oldAvg) {
            return;
        }
        String msg = String.format("Average cleaner backlog has grown from %.1f to %.1f. If the cleaner continues to be unable to make progress, the JE cache size and/or number of cleaner threads are probably too small. If this is not corrected, eventually all available disk space will be used.", Float.valueOf(oldAvg), Float.valueOf(newAvg));
        LoggerUtils.logMsg(this.logger, this.env, Level.SEVERE, msg);
    }

    private static float getAverage(Collection<Integer> integers) {
        float total = 0.0f;
        for (int i : integers) {
            total += (float)i;
        }
        return total / (float)integers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPending() throws DatabaseException {
        if (!this.processPendingReentrancyGuard.compareAndSet(false, true)) {
            return;
        }
        try {
            DatabaseId[] pendingDBs;
            DbTree dbMapTree = this.env.getDbTree();
            Map<Long, LNInfo> pendingLNs = this.fileSelector.getPendingLNs();
            if (pendingLNs != null) {
                TreeLocation location = new TreeLocation();
                for (Map.Entry<Long, LNInfo> entry : pendingLNs.entrySet()) {
                    Object var14_14;
                    long originalLsn = entry.getKey();
                    LNInfo info = entry.getValue();
                    DatabaseId dbId = info.getDbId();
                    DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                    try {
                        byte[] key = info.getKey();
                        LN ln = info.getLN();
                        this.env.daemonEviction(true);
                        this.processPendingLN(originalLsn, ln, db, key, location);
                        var14_14 = null;
                        dbMapTree.releaseDb(db);
                    }
                    catch (Throwable throwable) {
                        var14_14 = null;
                        dbMapTree.releaseDb(db);
                        throw throwable;
                    }
                    this.env.sleepAfterBackgroundIO();
                }
            }
            if ((pendingDBs = this.fileSelector.getPendingDBs()) != null) {
                for (DatabaseId dbId : pendingDBs) {
                    Object var16_17;
                    DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                    try {
                        if (db == null || db.isDeleteFinished()) {
                            this.fileSelector.removePendingDB(dbId);
                        }
                        var16_17 = null;
                        dbMapTree.releaseDb(db);
                    }
                    catch (Throwable throwable) {
                        var16_17 = null;
                        dbMapTree.releaseDb(db);
                        throw throwable;
                    }
                }
            }
            Object var18_19 = null;
            this.processPendingReentrancyGuard.set(false);
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            this.processPendingReentrancyGuard.set(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPendingLN(long originalLsn, LN ln, DatabaseImpl db, byte[] key, TreeLocation location) throws DatabaseException {
        IN bin;
        Locker locker;
        boolean completed;
        boolean obsolete;
        boolean lockDenied;
        boolean processedHere;
        block27: {
            block26: {
                block25: {
                    block23: {
                        block24: {
                            boolean parentFound = false;
                            processedHere = true;
                            lockDenied = false;
                            obsolete = false;
                            completed = false;
                            locker = null;
                            bin = null;
                            try {
                                try {
                                    this.nPendingLNsProcessed.increment();
                                    if (db == null || db.isDeleted()) {
                                        this.addPendingDB(db);
                                        this.nLNsDead.increment();
                                        obsolete = true;
                                        completed = true;
                                        Object var18_13 = null;
                                        if (bin == null) break block23;
                                        break block24;
                                    }
                                    Tree tree = db.getTree();
                                    assert (tree != null);
                                    locker = BasicLocker.createBasicLocker(this.env, false);
                                    locker.setPreemptable(false);
                                    LockResult lockRet = locker.nonBlockingLock(originalLsn, LockType.READ, false, db);
                                    if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                                        this.nPendingLNsLocked.increment();
                                        lockDenied = true;
                                        completed = true;
                                        break block25;
                                    }
                                    parentFound = tree.getParentBINForChildLN(location, key, false, true, UPDATE_GENERATION);
                                    bin = location.bin;
                                    int index = location.index;
                                    if (!parentFound) {
                                        this.nLNsDead.increment();
                                        obsolete = true;
                                        completed = true;
                                        break block26;
                                    }
                                    processedHere = false;
                                    this.migrateLN(db, bin.getLsn(index), (BIN)bin, index, true, true, originalLsn, true, CLEAN_PENDING_LN);
                                    completed = true;
                                    break block27;
                                }
                                catch (DatabaseException DBE) {
                                    DBE.printStackTrace();
                                    LoggerUtils.traceAndLogException(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
                                    throw DBE;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var18_17 = null;
                                if (bin != null) {
                                    bin.releaseLatch();
                                }
                                if (locker != null) {
                                    locker.operationEnd();
                                }
                                if (!processedHere) throw throwable;
                                if (completed && !lockDenied) {
                                    this.fileSelector.removePendingLN(originalLsn);
                                }
                                this.logFine(CLEAN_PENDING_LN, ln, -1L, completed, obsolete, false);
                                throw throwable;
                            }
                        }
                        bin.releaseLatch();
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    if (!processedHere) return;
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(originalLsn);
                    }
                    this.logFine(CLEAN_PENDING_LN, ln, -1L, completed, obsolete, false);
                    return;
                }
                Object var18_14 = null;
                if (bin != null) {
                    bin.releaseLatch();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                if (!processedHere) return;
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(originalLsn);
                }
                this.logFine(CLEAN_PENDING_LN, ln, -1L, completed, obsolete, false);
                return;
            }
            Object var18_15 = null;
            if (bin != null) {
                bin.releaseLatch();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            if (!processedHere) return;
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(originalLsn);
            }
            this.logFine(CLEAN_PENDING_LN, ln, -1L, completed, obsolete, false);
            return;
        }
        Object var18_16 = null;
        if (bin != null) {
            bin.releaseLatch();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        if (!processedHere) return;
        if (completed && !lockDenied) {
            this.fileSelector.removePendingLN(originalLsn);
        }
        this.logFine(CLEAN_PENDING_LN, ln, -1L, completed, obsolete, false);
    }

    public boolean isEvictable(BIN bin, int index, boolean latched) {
        if (bin.getDirty()) {
            if (bin.getMigrate(index)) {
                return false;
            }
            if (!latched) {
                return true;
            }
            long lsn = bin.getLsn(index);
            if (lsn == -1L) {
                return true;
            }
            Long fileNum = DbLsn.getFileNumber(lsn);
            if (this.foregroundProactiveMigration && this.toBeCleanedFiles.contains(fileNum)) {
                return false;
            }
            if ((this.clusterAll || this.clusterResident) && this.lowUtilizationFiles.contains(fileNum)) {
                return false;
            }
        }
        return true;
    }

    public void lazyMigrateLNs(final BIN bin, boolean backgroundIO) throws DatabaseException {
        DatabaseImpl db = bin.getDatabase();
        Integer[] sortedIndices = null;
        int nSortedIndices = 0;
        int nEntries = bin.getNEntries();
        for (int index = 0; index < nEntries; ++index) {
            boolean migrateFlag = bin.getMigrate(index);
            boolean isResident = bin.getTarget(index) != null;
            long childLsn = bin.getLsn(index);
            if (childLsn == -1L || !this.shouldMigrateLN(migrateFlag, isResident, backgroundIO, childLsn)) continue;
            if (isResident) {
                this.migrateLN(db, childLsn, bin, index, migrateFlag, false, 0L, backgroundIO, CLEAN_MIGRATE_LN);
                continue;
            }
            if (sortedIndices == null) {
                sortedIndices = new Integer[nEntries];
            }
            sortedIndices[nSortedIndices++] = index;
        }
        if (sortedIndices != null) {
            Arrays.sort(sortedIndices, 0, nSortedIndices, new Comparator<Integer>(){

                @Override
                public int compare(Integer int1, Integer int2) {
                    return DbLsn.compareTo(bin.getLsn(int1), bin.getLsn(int2));
                }
            });
            for (int i = 0; i < nSortedIndices; ++i) {
                int index = sortedIndices[i].intValue();
                long childLsn = bin.getLsn(index);
                boolean migrateFlag = bin.getMigrate(index);
                this.migrateLN(db, childLsn, bin, index, migrateFlag, false, 0L, backgroundIO, CLEAN_MIGRATE_LN);
            }
        }
    }

    private boolean shouldMigrateLN(boolean migrateFlag, boolean isResident, boolean backgroundIO, long childLsn) {
        if (migrateFlag) {
            this.nMarkedLNsProcessed.increment();
            return true;
        }
        if (this.env.isClosing()) {
            return false;
        }
        Long fileNum = DbLsn.getFileNumber(childLsn);
        if ((isResident || (backgroundIO ? this.backgroundProactiveMigration : this.foregroundProactiveMigration)) && this.toBeCleanedFiles.contains(fileNum)) {
            this.nToBeCleanedLNsProcessed.increment();
            return true;
        }
        if ((this.clusterAll || this.clusterResident && isResident) && this.lowUtilizationFiles.contains(fileNum)) {
            this.nClusterLNsProcessed.increment();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateLN(DatabaseImpl db, long lsn, BIN bin, int index, boolean wasCleaned, boolean isPending, long lockedPendingLsn, boolean backgroundIO, String cleanAction) throws DatabaseException {
        LN ln;
        BasicLocker locker;
        boolean clearTarget;
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        block66: {
            block65: {
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    obsolete = false;
                                    migrated = false;
                                    lockDenied = false;
                                    completed = false;
                                    clearTarget = false;
                                    locker = null;
                                    ln = null;
                                    try {
                                        Long fileNum;
                                        if (lsn == -1L) {
                                            completed = true;
                                            Object var22_17 = null;
                                            if (!isPending) break block60;
                                            if (completed && !lockDenied) {
                                                this.fileSelector.removePendingLN(lockedPendingLsn);
                                            }
                                            break block61;
                                        }
                                        if (!bin.isEntryKnownDeleted(index) && (ln = (LN)bin.getTarget(index)) == null) {
                                            ln = (LN)bin.fetchTarget(index);
                                            boolean bl = clearTarget = !db.getId().equals(DbTree.ID_DB_ID);
                                        }
                                        if (ln == null) {
                                            if (wasCleaned) {
                                                this.nLNsDead.increment();
                                            }
                                            obsolete = true;
                                            completed = true;
                                            break block62;
                                        }
                                        if (lockedPendingLsn != lsn) {
                                            locker = BasicLocker.createBasicLocker(this.env, false);
                                            locker.setPreemptable(false);
                                            LockResult lockRet = locker.nonBlockingLock(lsn, LockType.READ, false, db);
                                            if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                                                if (wasCleaned) {
                                                    this.nLNsLocked.increment();
                                                }
                                                lockDenied = true;
                                                completed = true;
                                                break block63;
                                            }
                                        }
                                        if (ln.isDeleted()) {
                                            bin.setKnownDeleted(index);
                                            if (wasCleaned) {
                                                this.nLNsDead.increment();
                                            }
                                            obsolete = true;
                                            completed = true;
                                            break block64;
                                        }
                                        if (bin.getMigrate(index) && !this.fileSelector.isFileCleaningInProgress(fileNum = Long.valueOf(DbLsn.getFileNumber(lsn)))) {
                                            obsolete = true;
                                            completed = true;
                                            if (wasCleaned) {
                                                this.nLNsDead.increment();
                                            }
                                            break block65;
                                        }
                                        long newLNLsn = ln.log(this.env, db, bin.getKey(index), lsn, backgroundIO, Cleaner.getMigrationRepContext(ln));
                                        bin.updateEntry(index, newLNLsn);
                                        this.nLNsMigrated.increment();
                                        CursorImpl.lockAfterLsnChange(db, lsn, newLNLsn, locker);
                                        migrated = true;
                                        completed = true;
                                        break block66;
                                    }
                                    catch (Throwable throwable) {
                                        Object var22_23 = null;
                                        if (isPending) {
                                            if (completed && !lockDenied) {
                                                this.fileSelector.removePendingLN(lockedPendingLsn);
                                            }
                                        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                                            this.fileSelector.addPendingLN(lsn, ln, db.getId(), bin.getKey(index));
                                            if (!this.areThreadsRunning()) {
                                                this.env.getUtilizationTracker().activateCleaner();
                                            }
                                            clearTarget = false;
                                        }
                                        bin.setMigrate(index, false);
                                        if (clearTarget) {
                                            bin.evictLN(index);
                                        }
                                        if (locker != null) {
                                            locker.operationEnd();
                                        }
                                        this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                                        throw throwable;
                                    }
                                }
                                if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                                    this.fileSelector.addPendingLN(lsn, ln, db.getId(), bin.getKey(index));
                                    if (!this.areThreadsRunning()) {
                                        this.env.getUtilizationTracker().activateCleaner();
                                    }
                                    clearTarget = false;
                                }
                            }
                            bin.setMigrate(index, false);
                            if (clearTarget) {
                                bin.evictLN(index);
                            }
                            if (locker != null) {
                                locker.operationEnd();
                            }
                            this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                            return;
                        }
                        Object var22_18 = null;
                        if (isPending) {
                            if (completed && !lockDenied) {
                                this.fileSelector.removePendingLN(lockedPendingLsn);
                            }
                        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                            this.fileSelector.addPendingLN(lsn, ln, db.getId(), bin.getKey(index));
                            if (!this.areThreadsRunning()) {
                                this.env.getUtilizationTracker().activateCleaner();
                            }
                            clearTarget = false;
                        }
                        bin.setMigrate(index, false);
                        if (clearTarget) {
                            bin.evictLN(index);
                        }
                        if (locker != null) {
                            locker.operationEnd();
                        }
                        this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                        return;
                    }
                    Object var22_19 = null;
                    if (isPending) {
                        if (completed && !lockDenied) {
                            this.fileSelector.removePendingLN(lockedPendingLsn);
                        }
                    } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                        this.fileSelector.addPendingLN(lsn, ln, db.getId(), bin.getKey(index));
                        if (!this.areThreadsRunning()) {
                            this.env.getUtilizationTracker().activateCleaner();
                        }
                        clearTarget = false;
                    }
                    bin.setMigrate(index, false);
                    if (clearTarget) {
                        bin.evictLN(index);
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                    return;
                }
                Object var22_20 = null;
                if (isPending) {
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(lockedPendingLsn);
                    }
                } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                    this.fileSelector.addPendingLN(lsn, ln, db.getId(), bin.getKey(index));
                    if (!this.areThreadsRunning()) {
                        this.env.getUtilizationTracker().activateCleaner();
                    }
                    clearTarget = false;
                }
                bin.setMigrate(index, false);
                if (clearTarget) {
                    bin.evictLN(index);
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                return;
            }
            Object var22_21 = null;
            if (isPending) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(lockedPendingLsn);
                }
            } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                this.fileSelector.addPendingLN(lsn, ln, db.getId(), bin.getKey(index));
                if (!this.areThreadsRunning()) {
                    this.env.getUtilizationTracker().activateCleaner();
                }
                clearTarget = false;
            }
            bin.setMigrate(index, false);
            if (clearTarget) {
                bin.evictLN(index);
            }
            if (locker != null) {
                locker.operationEnd();
            }
            this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
            return;
        }
        Object var22_22 = null;
        if (isPending) {
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(lockedPendingLsn);
            }
        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
            this.fileSelector.addPendingLN(lsn, ln, db.getId(), bin.getKey(index));
            if (!this.areThreadsRunning()) {
                this.env.getUtilizationTracker().activateCleaner();
            }
            clearTarget = false;
        }
        bin.setMigrate(index, false);
        if (clearTarget) {
            bin.evictLN(index);
        }
        if (locker != null) {
            locker.operationEnd();
        }
        this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
    }

    static ReplicationContext getMigrationRepContext(LN ln) {
        long vlsnSeq = ln.getVLSNSequence();
        if (vlsnSeq <= 0L) {
            return ReplicationContext.NO_REPLICATE;
        }
        return new ReplicationContext(new VLSN(vlsnSeq), false);
    }

    void addPendingDB(DatabaseImpl db) {
        DatabaseId id;
        if (db != null && db.isDeleted() && !db.isDeleteFinished() && this.fileSelector.addPendingDB(id = db.getId())) {
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, "CleanAddPendingDB " + id);
        }
    }

    void logFine(String action, Node node, long logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(action);
            if (node instanceof IN) {
                sb.append(" node=");
                sb.append(((IN)node).getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, sb.toString());
        }
    }

    public void close() {
        this.profile.close();
        this.tracker.close();
        this.fileSelector.close(this.env.getMemoryBudget());
    }
}

