open Fft_types
open Gengenlet

module Arr :
sig
  include Fft_unstaged.ARRAY with type elem = complex_sd

  type elem_ = Complex.t

  (** Build an [Arr.t] value from an [array code] value. *) 
  val mk : 'n nat -> elem_ array code -> 'n t

  (** Build an [array code] value from an [Arr.t] value. *) 
  val dyn : 'n t -> elem_ array code
end =
struct
  include Fft_unstaged.Make_arr(struct type elem = complex_sd end)
  type elem_ = Complex.t

  (* Question 2(b)(i) *)
  let mk : type n. n nat -> Complex.t array code -> n t =
    fun t -> assert false (* TODO *)

  (* Question 2(b)(i) *)
  let dyn : type n. n t -> Complex.t array code =
    fun t -> assert false (* TODO *)
end

let w n j = Sta (Fft_unstaged.w n j)

let merge l1 l2 =
  let open Complex_staged in
  let n = 2 * Arr.length l1 in
  let a, b = Arr.map2i
      (fun j x y ->
         let z1 = mul (w n j) y in
         let zx = add x z1 in
         let zy = sub x z1 in
         zx, zy)
      l1 l2
  in Arr.append a b

let rec fft : type n. n Arr.t -> n Arr.t =
  fun arr -> match Arr.explength arr with
      Z -> arr
    | S _ -> let (evens,odds) = Arr.split arr in
             merge (fft evens) (fft odds)

(* Question 2(b)(ii) *)
(** A code generator for building an FFT implementation specialized to
    a particular array size. *)
let mk : type n. n nat -> (Complex.t array -> Complex.t array) code =
  fun n -> assert false (* TODO *)
