`timescale 1ns/1ps

module yarvi_test ();
	logic clk = 1;
	logic rst_n;

	wire [25:0] avs_mm_address;
	wire        avs_mm_readenable;
	wire [31:0] avs_mm_readdata;
	wire        avs_mm_readdatavalid;
	wire        avs_mm_waitrequest;
	wire        avs_mm_writeenable;
	wire [31:0] avs_mm_writedata;
	wire [3:0]  avs_mm_byteena;

	yarvi_avalon avalon0 (
		.clk(clk),
		.rst_n(rst_n),
		.avs_mm_slave_address(avs_mm_address),
		.avs_mm_slave_readenable(avs_mm_readenable),
		.avs_mm_slave_readdata(avs_mm_readdata),
		.avs_mm_slave_readdatavalid(avs_mm_readdatavalid),
		.avs_mm_slave_waitrequest(avs_mm_waitrequest),
		.avs_mm_slave_writeenable(avs_mm_writeenable),
		.avs_mm_slave_writedata(avs_mm_writedata),
		.avs_mm_slave_byteena(avs_mm_byteena)
	);
	
	yarvi y0 (
		.clk(clk),
		.rst_n(rst_n),
		.do_pause(0),
		.avs_mm_master_address(avs_mm_address),
		.avs_mm_master_readenable(avs_mm_readenable),
		.avs_mm_master_readdata(avs_mm_readdata),
		.avs_mm_master_readdatavalid(avs_mm_readdatavalid),
		.avs_mm_master_waitrequest(avs_mm_waitrequest),
		.avs_mm_master_writeenable(avs_mm_writeenable),
		.avs_mm_master_writedata(avs_mm_writedata),
		.avs_mm_master_byteena(avs_mm_byteena)
	);
	
	/* Drive clock and reset signal */
	initial begin
		forever #10 clk = ~clk;
	end
	
	initial begin
		#0 rst_n = 0;
		#40 rst_n = 1;
	end
	
endmodule