module yarvi_avalon (
	input wire        clk,
	input wire        rst_n,
	input wire [25:0] avs_mm_slave_address,
	input wire        avs_mm_slave_readenable,
	output reg [31:0] avs_mm_slave_readdata,
	output reg        avs_mm_slave_readdatavalid,
	output wire       avs_mm_slave_waitrequest,
	input wire        avs_mm_slave_writeenable,
	input wire [31:0] avs_mm_slave_writedata,
	input wire [3:0]  avs_mm_slave_byteena
);

	import "DPI-C" function void yarvi_avalon_setup();
	import "DPI-C" function int yarvi_avalon_read_mem(input int address, input byte byteena);
	import "DPI-C" function void yarvi_avalon_write_mem(input int address, input int data, input byte byteena);
	
	assign avs_mm_slave_waitrequest = 0;

	always @(posedge clk) begin
		if (!rst_n) begin
			avs_mm_slave_readdata <= 0;
			avs_mm_slave_readdatavalid <= 0;
			yarvi_avalon_setup();
		end else begin
			if (avs_mm_slave_readenable) begin
				avs_mm_slave_readdata <= yarvi_avalon_read_mem(avs_mm_slave_address, avs_mm_slave_byteena);
				avs_mm_slave_readdatavalid <= 1;
			end else
				avs_mm_slave_readdatavalid <= 0;
			
			if (avs_mm_slave_writeenable)
				yarvi_avalon_write_mem(avs_mm_slave_address, avs_mm_slave_writedata, avs_mm_slave_byteena);
		end
	end
endmodule
