#!/usr/bin/env python

# Convert the Yarvi .txt format to Altera .mif

import sys
import re
import datetime

if len(sys.argv) != 4 and len(sys.argv) != 5:
	sys.exit("Syntax: %s <infile> <outfile> <width in bits> [<length in words to pad to>]" % sys.argv[0])

if sys.argv[1] == '-':
	txt = sys.stdin
else:
	txt = open(sys.argv[1], 'r')

mif = open(sys.argv[2], 'w')
# width of output in bits
width = int(sys.argv[3]);
if len(sys.argv) > 4:
	pad_length = int(sys.argv[4]);
else:
	pad_length = -1

# read in the whole memory contents
txtfile = txt.read()
txt.close()

# strip newlines
txtfile = txtfile.replace('\n', '')
# check no extra characters
#print txtfile
otherchar = re.compile(r'[^a-fA-F0-9]+')
s = otherchar.search(txtfile)
if s:
	print "Invalid character %s found at char %d" % (s.group(0),s.start())
	sys.exit(1)
# calculate length
#if len(txtfile)==0:
#	txtfile = "00";


bytes = len(txtfile)/2;
words = bytes/(width/8);
if pad_length > words:
	words = pad_length

if sys.argv[1] == '-':
	inputfile = 'stdin'
else:
	inputfile = sys.argv[1]

mif.write('-- Generated by txt2mif\n')
mif.write('-- from %s\n' % inputfile)
mif.write('-- %s\n' % datetime.datetime.now().ctime())
mif.write('\n')
mif.write('DEPTH = %d;\n' % words);
mif.write('WIDTH = %d;\n' % width)
mif.write('ADDRESS_RADIX = HEX;\n')
mif.write('DATA_RADIX = HEX;\n');
mif.write('CONTENT\n');
mif.write('BEGIN\n');
if bytes > 0:
	for addr in range(0,bytes,width/8):
		hexbyte=[]
		for byte in range(0,width/8):
			hexbyte.append(txtfile[(addr+byte)*2]+txtfile[(addr+byte)*2+1])
		mif.write('%08x : %s;\n' % (addr/(width/8),"".join(hexbyte)))
		words = words-1
else:
	addr = -1

for word in range(addr/(width/8)+1,addr/(width/8)+words+1):
	mif.write('%08x : %s;\n' % (word,"0" * (width/4)))
mif.write('END;\n');
mif.close()
