`timescale 1ns/1ps

module yarvi_test ();
	logic clk = 1;
	logic rst_n;

	wire [25:0] avs_mm_address;
	wire        avs_mm_readenable;
	wire [31:0] avs_mm_readdata;
	wire        avs_mm_readdatavalid;
	wire        avs_mm_waitrequest;
	wire        avs_mm_writeenable;
	wire [31:0] avs_mm_writedata;
	wire [3:0]  avs_mm_byteena;

	yarvi_avalon avalon0 (
		.clk(clk),
		.rst_n(rst_n),
		.avs_mm_slave_address(avs_mm_address),
		.avs_mm_slave_readenable(avs_mm_readenable),
		.avs_mm_slave_readdata(avs_mm_readdata),
		.avs_mm_slave_readdatavalid(avs_mm_readdatavalid),
		.avs_mm_slave_waitrequest(avs_mm_waitrequest),
		.avs_mm_slave_writeenable(avs_mm_writeenable),
		.avs_mm_slave_writedata(avs_mm_writedata),
		.avs_mm_slave_byteena(avs_mm_byteena)
	);
	
	yarvi y0 (
		.clk(clk),
		.rst_n(rst_n),
		.soft_rst_n(1'b1),
		.do_pause(1'b0),
		  // peripheral bus
		.avs_mm_master_address(avs_mm_address),
		.avs_mm_master_readenable(avs_mm_readenable),
		.avs_mm_master_readdata(avs_mm_readdata),
		.avs_mm_master_readdatavalid(avs_mm_readdatavalid),
		.avs_mm_master_waitrequest(avs_mm_waitrequest),
		.avs_mm_master_writeenable(avs_mm_writeenable),
		.avs_mm_master_writedata(avs_mm_writedata),
		.avs_mm_master_byteena(avs_mm_byteena),
		  // ignore host processor bus to instruction memory which we're not using
		.avs_instruction_address(10'd0),
		.avs_instruction_writedata(32'd0),
		.avs_instruction_write(1'b0),
		.avs_instruction_read(1'b0),
		.avs_instruction_readdata(), // throw away and data read (since we won't read any)
		  // ignore host processor bus to data memory which we're not using
		.avs_data_address(10'd0),
		.avs_data_writedata(32'd0),
		.avs_data_write(1'b0),
		.avs_data_read(1'b0),
		.avs_data_readdata(), // throw away and data read (since we won't read any)
		  // bin instruction trace port
	        .fetched_instruction()
	     );
	
	/* Drive clock and reset signal */
	initial begin
		forever #10 clk = ~clk;
	end
	
	initial begin
		#0 rst_n = 0;
		#40 rst_n = 1;
	end
	
endmodule
