# start a new library
vlib work
vmap work work

# determine whether we're on a 32 or 64 bit Modelsim...
set MODEL_TECH $::env(MODEL_TECH)
set sixtyfour [string first "64" $MODEL_TECH]
if {$sixtyfour == "-1"} {
	set ARCH "-m32"
} else {
	set ARCH "-m64"
}

# ... and compile the Yarvi Avalon emulator as an appropriate kind of shared library
gcc -shared $ARCH -fPIC -I $MODEL_TECH/../include/ -o yarvi_avalon.so yarvi_avalon.c

vlog yarvi_avalon.sv
vlog yarvi.sv
vlog yarvi_test.sv

# link the compiled Verilog with the C shared library into a simulator
vsim -novopt -sv_lib yarvi_avalon work.yarvi_test

# add signals to the waveform viewer
add wave -position insertpoint  \
sim:/yarvi_test/clk \
sim:/yarvi_test/rst_n \
sim:/yarvi_test/avs_mm_address \
sim:/yarvi_test/avs_mm_readenable \
sim:/yarvi_test/avs_mm_readdatavalid \
sim:/yarvi_test/avs_mm_writeenable \
sim:/yarvi_test/avs_mm_byteena \
sim:/yarvi_test/y0/ex_next_pc \
sim:/yarvi_test/y0/if_pc \
sim:/yarvi_test/y0/de_inst

