/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.bitvisualiser;

import uk.ac.cam.acr31.bitvisualiser.Util;

public class Bitwise {
    public static void main(String[] args) {
        if (args.length < 3 || args[0].matches(".*[^01].*") || args[1].matches("[AND|OR|XOR]") || args[2].matches(".*[^01].*")) {
            System.out.println("Usage: Bitwise  [binarynumber] AND [binarynumber]");
            System.out.println("or:    Bitwise  [binarynumber] OR  [binarynumber]");
            System.out.println("or:    Bitwise  [binarynumber] XOR [binarynumber]");
            System.exit(-1);
        }
        String a = args[0];
        String b = args[2];
        String opcode = args[1];
        char jOpcode = '&';
        if (opcode.matches("OR")) {
            jOpcode = '|';
        }
        if (opcode.matches("XOR")) {
            jOpcode = '^';
        }
        while (a.length() < b.length()) {
            a = "0" + a;
        }
        while (b.length() < a.length()) {
            b = "0" + b;
        }
        Util.typeln("Defining two variables a=" + a + " and b=" + b);
        Util.typeln("The result of " + a + " " + opcode + " " + b + " (written 'a " + jOpcode + " b' in Java) can be calculated as follows:\n");
        char[] c = new char[a.length()];
        int i = 0;
        while (i < a.length()) {
            int valA = a.charAt(i) == '1' ? 1 : 0;
            int valB = b.charAt(i) == '1' ? 1 : 0;
            int result = valA & valB;
            if (jOpcode == '|') {
                result = valA | valB;
            }
            if (jOpcode == '^') {
                result = valA ^ valB;
            }
            Util.typeln(" The value of a at position " + (a.length() - i - 1) + " is " + valA);
            Util.typeln(" The value of b at position " + (a.length() - i - 1) + " is " + valB);
            Util.typeln("  => The value of 'a " + jOpcode + " b' at position " + (a.length() - i - 1) + " is " + result);
            System.out.println();
            c[i] = result == 1 ? 49 : 48;
            ++i;
        }
        Util.typeln("Therefore the result of a " + jOpcode + " b is " + new String(c));
    }
}

