package uk.ac.cam.rkh23.Generics;

// Pair has two type parameters, X and Y.
// These are filled in at compile time (so, 
// e.g. "X" becomes "Integer"). But the info is 
// only retained by the compiler - the output bytecode
// has lost that info (see "type erasure")
public class Pair <X,Y>{
	private X mX;
	private Y mY;
	
	// Constructor
	public Pair(X x, Y y) {
		mX=x;
		mY=y;
	}
	
	// Accessors (keep it immutable for now)
	public X getX() { return mX;}
	public Y getY() { return mY;}
	
	// Samples of usage
	public static void main(String[] args) {
		// a pair of an integer and a string
		Pair<Integer,String> p = new Pair<Integer,String>(3,"Hello");
		
		// a pair of two strings
		Pair<String,String> p2 = new Pair<String,String>("Good","bye");
		
	}
	

}
