package uk.ac.cam.rkh23.Generics;

import java.util.LinkedList;
import java.util.TreeMap;

public class GenericsDemo {

	public static void main(String[] args) {
		// Using a linked list structure
		LinkedList<String> l = new LinkedList<String>();
		l.add(new String("Object"));
		l.add(new String("Oriented"));
		// Trying to add anything without String as a base class
		// will result in a *compile* error. E.g. try
		// l.add(new Integer(3));
		
		for (String s : l) System.out.println(s);
		
				
		// This sets up a map (or dictionary) between Integer keys and 
		// String values.
		TreeMap<Integer,Double> tm = new TreeMap<Integer,Double>();
		// Add entries
		tm.put(new Integer(3), new Double(8.0));
		tm.put(new Integer(7), new Double(10.0));
		// Get entries
		Double val = tm.get(new Integer(3));
		System.out.println(val);
		
		// Try doing a lookup in the map without using a
		// key of type Integer (i.e. some other 
		// type such as String).  What happens at compile 
		// and run time? Why (hard)?
		tm.get(new String("kk"));
		
	}
}
