package uk.ac.cam.rkh23.Comparing;

public class EqualsTest {
	
	    public int x = 8;

	    // BAD: doesn't actually override anything since the
	    // declaration in Object takes an Object, not an EqualsTest!
	    public boolean equals(EqualsTest o) {
	        return (this.x==o.x);
	    }
	    
	    /**
	     * The correct version
	    @Override
	    public boolean equals(Object o) {
	    	EqualsTest e = (EqualsTest)o;
	        return (this.x==e.x);
	    }
	    */
	    
	    public static void main(String args[]) {
	        EqualsTest t1 = new EqualsTest();
	        EqualsTest t2 = new EqualsTest();
	        Object o1 = (Object)t1;
	        Object o2 = (Object)t2;
	        System.out.println(t1==t2);
	        System.out.println(t1.equals(t2));
	        System.out.println(o1.equals(o2));
	    }
	
}
