package uk.ac.cam.rkh23.Comparing.AdmissionsData;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class SubjectData implements Comparable<SubjectData>{
	
	private String mSubject;
	private int mMaleApply;
	private int mFemaleApply;
	private int mMaleIn;
	private int mFemaleIn;
	
	public String getSubject() {return mSubject;}
	public int getMaleApply() {	return mMaleApply;}
	public int getFemaleApply() {return mFemaleApply;}
	public int getMaleActual() {return mMaleIn;}
	public int getFemaleActual() {return mFemaleIn;}

	public SubjectData(String subject, 
			int maleapply, 
			int femaleapply, 
			int malein, 
			int femalein){
		mSubject=subject;
		mMaleApply=maleapply;
		mFemaleApply=femaleapply;
		mMaleIn=malein;
		mFemaleIn=femalein;
	}
	
	public void print() {
		System.out.println(mSubject+"   "+mMaleApply+" "+mFemaleApply+" "+mMaleIn+" "+mFemaleIn);
	}
	
	@Override
	public int compareTo(SubjectData o) {
		return this.mSubject.compareTo(o.mSubject);
	}
	
	
	/**
	 * Comparator class
	 * @author robert
	 *
	 */
	public static class MaleApplyComp implements Comparator<SubjectData> {

		@Override
		public int compare(SubjectData o1, SubjectData o2) {
			if (o1.mMaleApply==o2.mMaleApply) return 0;
			else if (o1.mMaleApply<o2.mMaleApply) return -1;
			return 1;
		}
		
	}
	
	
	/**
	 * Another Comparator class
	 * @author robert
	 *
	 */
	public static class FemaleApplyComp implements Comparator<SubjectData> {

		@Override
		public int compare(SubjectData o1, SubjectData o2) {
			if (o1.mFemaleApply==o2.mFemaleApply) return 0;
			else if (o1.mFemaleApply<o2.mFemaleApply) return -1;
			return 1;
		}
		
	}
	
	public static void main(String[] args) {
		
		LinkedList<SubjectData> data = new LinkedList<>();
		
		File f = new File("uk/ac/cam/rkh23/Comparing/AdmissionsData/admissions.csv");
		try {
			BufferedReader br = new BufferedReader(new FileReader(f));
			
			String line=br.readLine();
			while(line!=null) {
				String[] tokens=line.split(",");
				SubjectData sd = new SubjectData(tokens[0],
						Integer.parseInt(tokens[1]),
						Integer.parseInt(tokens[2]),
						Integer.parseInt(tokens[3]),
						Integer.parseInt(tokens[4]));
				data.add(sd);
				line=br.readLine();
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// sort using natural order (Comparable)
		Collections.sort(data);
		for (SubjectData sd : data) {
			sd.print();
		}
		System.out.println("");
		
		
		// sort using a custom ordering (Comparator)
		Collections.sort(data, new MaleApplyComp());
		for (SubjectData sd : data) {
			sd.print();
		}
		System.out.println("");
		
		// sort using another custom ordering (Comparator)
		Collections.sort(data, new FemaleApplyComp());
		for (SubjectData sd : data) {
			sd.print();
		}
	}
	
	
	
}
