/*
 * Decompiled with CFR 0.152.
 */
package ttcasm.comparch.cl.cam.ac.uk;

import ttcasm.comparch.cl.cam.ac.uk.Generator;
import ttcasm.comparch.cl.cam.ac.uk.Instruction;
import ttcasm.comparch.cl.cam.ac.uk.Program;

public class ILcLab
implements Instruction {
    private byte rw = 0;
    private String lab = null;
    private Integer addr = null;

    protected ILcLab(byte by, String string) {
        this.rw = by;
        this.lab = string;
    }

    @Override
    public void Validate(Program program) throws Exception {
        if (this.rw < 0 | this.rw > 127) {
            throw new Exception("Invalid register (index not in range [0..127]) ");
        }
        this.addr = program.Resolve(this.lab);
        if (this.addr == null) {
            throw new Exception("Unresolved label " + this.lab);
        }
        if (this.addr >> 24 != 0) {
            throw new Exception("Program too long" + this.lab);
        }
    }

    @Override
    public void Generate(Generator generator) throws Exception {
        if (this.addr == null) {
            throw new Exception("Unresolved label " + this.lab);
        }
        generator.writeHeader();
        generator.write(this.rw, 7);
        generator.write(1, 1);
        generator.write(this.addr, 24);
        generator.writeFooter();
    }

    @Override
    public String toString() {
        return "LC RW=R" + this.rw + " LAB=" + this.lab + (this.addr != null ? " (" + this.addr + ")" : "");
    }
}

