/***********************************************************************
 *                                                                     *
 * File:     alt_ring_ttc_proc.c                                       *
 *                                                                     *
 * Purpose:  Driver procedures for the TTC ring processor              *
 *                                                                     *
 * Author:   Ben Thorner                                               *
 *           August 2012                                               *
 **********************************************************************/

#include <stdio.h>

#include "alt_ring_ttc_proc.h"
#include "altera_avalon_fifo_util.h"

alt_u32 request_addr;
alt_u32 request_csr_addr;

alt_u32 response_addr;
alt_u32 response_csr_addr;

int alt_ring_ttc_proc_init(alt_u32 rq_addr, alt_u32 rq_csr_addr, alt_u32 rs_addr, alt_u32 rs_csr_addr) {
	  // Setup addresses
	  request_addr = rq_addr;
	  request_csr_addr = rq_csr_addr;
	  response_addr = rs_addr;
	  response_csr_addr = rs_csr_addr;

	  int err;
	  // Initialise request FIFO
	  err = altera_avalon_fifo_init(
			  request_csr_addr,
			  0, 									// Disable interrupts,
			  5, 									// Almost empty level
			  123									// Almost full level
	  );

	  if (err != ALTERA_AVALON_FIFO_OK)
		  return err;

	  // Initialise response FIFO
	  err = altera_avalon_fifo_init(
			  response_csr_addr,
			  0,
			  5,
			  123
	  );

	  return err;
}

void request(int x0, int y0, unsigned int max_iter, unsigned int ttc_id) {
	while(altera_avalon_fifo_write_other_info(request_addr, request_csr_addr, ttc_id << 8)!= ALTERA_AVALON_FIFO_OK);
	while(altera_avalon_fifo_write_fifo(request_addr, request_csr_addr, x0)!= ALTERA_AVALON_FIFO_OK);
	while(altera_avalon_fifo_write_fifo(request_addr, request_csr_addr, y0)!= ALTERA_AVALON_FIFO_OK);
	while(altera_avalon_fifo_write_fifo(request_addr, request_csr_addr, max_iter)!= ALTERA_AVALON_FIFO_OK);
}

result response() {
	while(altera_avalon_fifo_read_level(response_csr_addr)==0);
	int data = altera_avalon_fifo_read_fifo(response_addr,response_csr_addr);
	int status = altera_avalon_fifo_read_other_info(response_addr);
	return (result) { .iter = data, .ttc_id = status >> 8 };
}
