
val verbose : bool ref 

type value = 
     | CON of Common.constant 
     | PAIR of value * value 
     | INL of value 
     | INR of value 
     | FUN of bool * closure    (* bool is a flag : true means recursive environment! *) 

and closure = code * env 


and instruction = 
  | PUSH of value 
  | UNARY of Past.unary_oper 
  | OPER of Past.oper 
  | TEST of code * code
  | CASE of code * code
  | IPAIR 
  | FST
  | SND
  | IINL
  | IINR
  | APPLY
  | LOOKUP of Past.var 
  | BIND of Past.var 
  | MK_CLOSURE of code * (Past.var list) 
  | MK_REC of Past.var * code * (Past.var list) 
  | SWAP_POP 

and code = instruction list 

and binding = Past.var * value

and env = binding list

type env_or_value = EV of env | V of value 

type env_value_stack = env_or_value list 

type state = code * env_value_stack 

val step : state -> state 

val compile : Ast.expr -> code 

val driver : int -> state -> value 

val eval : Ast.expr * env -> value 

val interpret : Ast.expr -> value 

val string_of_value : value -> string 

