
val verbose : bool ref 

type value = 
     | CON of Common.constant 
     | PAIR of value * value 
     | INL of value 
     | INR of value 
     | FUN of closure 

and closure = Past.var * Ast.expr * env 

and continuation = 
  | ID 
  | C_UNARY of Past.unary_oper * continuation
  | C_OPER of Past.oper * value * continuation
  | C_OPER_FST of Ast.expr * env * Past.oper * continuation
  | C_IF of Ast.expr * Ast.expr * env * continuation
  | C_PAIR of value * continuation
  | C_PAIR_FST of Ast.expr * env * continuation
  | C_FST of continuation
  | C_SND of continuation
  | C_INL of continuation
  | C_INR of continuation
  | C_CASE of Past.var * Ast.expr * Past.var * Ast.expr * env * continuation
  | C_APPLY of closure * continuation
  | C_ARG of Ast.expr * env * continuation

and env = Past.var -> value 

val eval_dfc : Ast.expr * env * continuation -> value

val apply_cnt : continuation * value -> value 

val apply_closure : closure * (continuation * value) -> value 

val eval : Ast.expr * env -> value 

val interpret : Ast.expr -> value 

val string_of_value : value -> string 

