
/* Auxiliary code */

%{

let get_loc = Parsing.symbol_start_pos 

%}

/* Tokens and types */
%token<int> INT
%token<string> IDENT
%token EOF LPAREN RPAREN COMMA COLON ADD SUB MUL NOT EQUAL LT ANDOP OROP 
%token WHAT UNIT AND TRUE FALSE IF THEN ELSE LET REC IN END BOOL INTTYPE UNITTYPE 
%token ARROW BAR INL INR FST SND FUN CASE OF 

%left ADD SUB            /* lowest precedence */
%left MUL AND OR EQUAL   /* medium precedence */
%nonassoc NOT  
%nonassoc UMINUS         /* highest precedence */

%start start
%type <Past.type_expr> texpr
%type <Past.expr> simple_expr 
%type <Past.expr> expr 
%type <Past.expr> start

%%

/* Grammar  */

start: 
| expr EOF { $1 }

/* problem 

   -e  (unary minus) 

    e e (application) 

    e1 - e2  (is the e1(-e2) or e1-e2???) 

*/

simple_expr:
| UNIT                               { Past.Unit (get_loc())}
| INT                                { Past.Integer (get_loc(), $1) }
| WHAT                               { Past.What (get_loc())} 
| IDENT                              { Past.Var (get_loc(), $1) }
| TRUE                               { Past.Boolean (get_loc(), true)}
| FALSE                              { Past.Boolean (get_loc(), false)}
| LPAREN expr RPAREN                 { $2 }
| LPAREN expr COMMA expr RPAREN      { Past.Pair(get_loc(), $2, $4) }

expr:
| simple_expr                        {  $1 }
| expr simple_expr                   { Past.App (get_loc(), $1, $2) }
| NOT expr                           { Past.UnaryOp(get_loc(), Past.NOT, $2) }
| SUB expr %prec UMINUS              { Past.UnaryOp(get_loc(), Past.NEG, $2) }
| expr ADD expr                      { Past.Op(get_loc(), $1, Past.ADD, $3) }
| expr SUB expr                      { Past.Op(get_loc(), $1, Past.SUB, $3) }
| expr MUL expr                      { Past.Op(get_loc(), $1, Past.MUL, $3) }
| expr LT expr                       { Past.Op(get_loc(), $1, Past.LT, $3) }
| expr EQUAL expr                    { Past.Op(get_loc(), $1, Past.EQ, $3) }
| expr ANDOP expr                    { Past.Op(get_loc(), $1, Past.AND, $3) }
| expr OROP expr                     { Past.Op(get_loc(), $1, Past.OR, $3) }
| IF expr THEN expr ELSE expr        { Past.If(get_loc(), $2, $4, $6) }
| FST expr                           { Past.Fst(get_loc(), $2) }
| SND expr                           { Past.Snd(get_loc(), $2) }
| INL expr                           { Past.Inl(get_loc(), $2) }
| INR expr                           { Past.Inr(get_loc(), $2) }
| FUN LPAREN IDENT COLON texpr RPAREN ARROW expr   
                                     { Past.Lambda(get_loc(), ($3, $5, $8)) } 
| LET bindings IN expr END           { Past.Let (get_loc(), $2, $4) }
| LET IDENT LPAREN IDENT COLON texpr RPAREN COLON texpr EQUAL expr IN expr END 
                                     { Past.LetFun (get_loc(), $2, ($4, $6, $11), $9, $13) }
| IDENT COLON texpr ARROW expr       { Past.Lambda(get_loc(), ($1, $3, $5))}
| CASE expr OF 
      INL IDENT ARROW expr 
  BAR INR IDENT ARROW expr 
  END 
                                     { Past.Case (get_loc(), $2, ($5, $7), ($10, $12)) }

bindings: 
| IDENT COLON texpr EQUAL expr       { [($1, $3, $5)] }
| IDENT COLON texpr EQUAL expr AND bindings        
                                     { ($1, $3, $5) :: $7 }
texpr: 
| BOOL                               { Past.TEbool  }
| INTTYPE                            { Past.TEint  }
| UNITTYPE                           { Past.TEunit  }
| texpr ARROW texpr                  { Past.TEarrow ($1, $3)}
| texpr MUL texpr                    { Past.TEproduct ($1, $3)}
| texpr ADD texpr                    { Past.TEunion ($1, $3)}
| LPAREN texpr RPAREN                { $2 } 




