
val verbose : bool ref 

type value = 
     | CON of Common.constant 
     | PAIR of value * value 
     | INL of value 
     | INR of value 
     | FUN of bool * closure    (* bool is a flag : true means recursive environment! *) 

and closure = Past.var * Ast.expr * env 

and directive = 
  | E of Ast.expr 
  | C_UNARY of Past.unary_oper 
  | C_OPER of Past.oper 
  | C_OPER_FST of Ast.expr * Past.oper 
  | C_IF of Ast.expr * Ast.expr 
  | C_PAIR 
  | C_PAIR_FST of Ast.expr 
  | C_FST
  | C_SND
  | C_INL
  | C_INR
  | C_CASE of Past.var * Ast.expr * Past.var * Ast.expr 
  | C_APPLY of closure 
  | C_ARG of Ast.expr 
  | SWAP_POP 

and directive_stack = directive  list

and binding = Past.var * value

and env = binding list

type env_or_value = EV of env | V of value 

type env_value_stack = env_or_value list 

type state = directive_stack * env_value_stack 

val step : state -> state 

val driver : int -> state -> value 

val eval : Ast.expr * env -> value 

val interpret : Ast.expr -> value 

val string_of_value : value -> string 

