
val verbose : bool ref 

type value = 
     | CON of Common.constant 
     | PAIR of value * value 
     | INL of value 
     | INR of value 
     | FUN of bool * closure    (* bool is a flag : true means recursive environment! *) 

and closure = Past.var * Ast.expr * env 

and continuation_item = 
  | C_UNARY of Past.unary_oper
  | C_OPER of Past.oper * value
  | C_OPER_FST of Ast.expr * env * Past.oper
  | C_IF of Ast.expr * Ast.expr * env
  | C_PAIR of value 
  | C_PAIR_FST of Ast.expr * env 
  | C_FST 
  | C_SND 
  | C_INL 
  | C_INR 
  | C_CASE of Past.var * Ast.expr * Past.var * Ast.expr * env 
  | C_APPLY of closure 
  | C_ARG of Ast.expr * env 

and continuation = continuation_item  list

and binding = Past.var * value

and env = binding list

type state = 
   | EVAL of Ast.expr * env * continuation 
   | APPLY of continuation * value 

val step : state -> state 

val driver : int -> state -> value 

val eval : Ast.expr * env -> value 

val interpret : Ast.expr -> value 

val string_of_value : value -> string 

