
val verbose : bool ref 

type value = 
     | CON of Common.constant 
     | PAIR of value * value 
     | INL of value 
     | INR of value 
     | FUN of closure 

and closure = code * env 

and instruction = 
  | PUSH of value 
  | UNARY of Past.unary_oper 
  | OPER of Past.oper 
  | TEST of code * code
  | CASE of code * code
  | IPAIR 
  | FST
  | SND
  | IINL
  | IINR
  | APPLY
  | DUP_ENV 
  | POP_ENV 
  | LOOKUP of Past.var 
  | BIND of Past.var 
  | MK_CLOSURE of code 
  | MK_REC of Past.var * code 

and code = instruction list 

and env = Past.var -> value 

type env_stack = env list 

type value_stack = value list 

type state = code * env_stack * value_stack 

val step : state -> state 

val driver : int -> state -> value 

val compile : Ast.expr -> code 

val eval : Ast.expr * env -> value 

val interpret : Ast.expr -> value 

val string_of_value : value -> string 
