
val verbose : bool ref 

type value = 
     | CON of Common.constant 
     | PAIR of value * value 
     | INL of value 
     | INR of value 
     | FUN of ((continuation * value) -> value)

and continuation = value -> value 

type env = Past.var -> value 

val eval_cps : Ast.expr * env * continuation -> value 

val eval :  Ast.expr * env -> value 

val interpret : Ast.expr -> value 

val string_of_value : value -> string 

