type expr = 
       | Unit  
       | Var of Past.var
       | Integer of int
       | Boolean of bool
       | UnaryOp of Past.unary_oper * expr
       | Op of expr * Past.oper * expr
       | If of expr * expr * expr
       | Pair of expr * expr
       | Fst of expr 
       | Snd of expr 
       | Inl of expr 
       | Inr of expr 
       | Case of expr * lambda * lambda 
       | Lambda of lambda 
       | App of expr * expr
       | LetFun of Past.var * lambda * expr
       | LetRecFun of Past.var * lambda * expr

and lambda = Past.var * expr 
