
val verbose : bool ref 

type basic_value = 
     | SIMPLE of Common.constant 
     | TUPLE of  Common.constant list 

type value = 
     | BASIC of basic_value 
     | FUN of (basic_value -> Common.constant)

type env = Ast.var -> value 

type state = env * Ast.expr 

type binding = Ast.var * value

type bindings = binding list

val constant_of_value : value -> Common.constant

val function_of_value : value -> (basic_value -> Common.constant)

val update : (env * binding) -> env

val bind_args : (env * Ast.formals * basic_value) -> env 

val eval : state -> Common.constant 

val eval_args : (env * (Ast.expr list)) -> Common.constant list

val interpret : Ast.expr -> Common.constant





