(* 

an expression such as 

          LetFun (f, [(x1, t1), ...., (xn, tn)], t, e1, e2) 
           
           represents something like SML's 

           let fun f (x1 : t1, ..., xn : tn) : t = e1
           in e2 end 

           while the expression 

          LetRecFun (f, [(x1, t1), ...., (xn, tn)], t, e1, e2) 
          
          indicates that f is a recursive function 

*) 
type var = string 

type formals = var list

type expr = 
       | Unit  
       | Var of var
       | Integer of int
       | Boolean of bool
       | If of expr * expr * expr
       | App of var * expr list
       | LetFun of var * formals * expr * expr
       | LetRecFun of var * formals * expr * expr


