
exception Error of string 

let complain s = raise (Error s) 

type constant = 
     | INT of int 
     | BOOL of bool 
     | UNIT

(* string_of_constant : constant -> string *) 
let string_of_constant = function 
    | BOOL b -> string_of_bool b
    | INT n -> string_of_int n 
    | UNIT -> "()"

(* bool_of_constant : constant -> bool *) 
let bool_of_constant = function 
    | BOOL b -> b
    | _ -> complain "gb : expecting a Boolean"


let string_of_list sep f l = 
   let rec aux f = function 
     | [] -> ""
     | [t] -> (f t)
     | t :: rest -> (f t) ^  sep  ^ (aux f rest)
   in "[" ^ (aux f l) ^ "]"

let readint () = let _ = print_string "input> " in read_int() 



