package uk.ac.cam.rkh23.ExamplesClass.TickStore;

import java.awt.List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import uk.ac.cam.rkh23.ExamplesClass.Logging.Logger;

public class TickStore {
	
	/// CRSID->Student
	private Map<String,Student> mIDs = 
			new HashMap<String,Student>();
	
	// Student->ticks
	private Map<Student,Integer> mTicks = 
			new HashMap<Student,Integer>();
	
	// College->DoS
	private Map<String,DoS> mDoSes = 
			new HashMap<String,DoS>();
	
	public void addStudent(Student s) throws DuplicatePerson {
		if (mIDs.containsKey(s.getCRSID()))
			throw new DuplicatePerson();
		mTicks.put(s, 0);
		mIDs.put(s.getCRSID(), s);
	}
	
	public void addDoS(DoS d) {
		mDoSes.put(d.getCollege(), d);
	}
	
	public void addTick(String CRSID) throws StudentNotFound {
		Student student = mIDs.get(CRSID);
		if (student==null)throw new StudentNotFound();
		Integer current = mTicks.get(student);
		mTicks.put(student, current+1);
		
	}
	
	public void print() {
		TreeMap<Student,Integer> sorted = 
				new TreeMap<Student,Integer>(mTicks);
		
		for (Map.Entry<Student,Integer> e : sorted.entrySet()) {
			Student s =e.getKey();
			Integer ticks = e.getValue();
			DoS d = mDoSes.get(s.getCollege());
			System.out.println(s.getCRSID()+" "+s.getSurname()+" "+
		mTicks.get(s) + " "+d.getSurname());
		}
	}
	
	
	public void printByCollege() {
		TreeMap<Student,Integer> sorted = 
		new TreeMap<Student,Integer>(new CollegeComparator());
		sorted.putAll(mTicks);
		Logger.getInstance().log("Something here");
		
		for (Map.Entry<Student,Integer> e : sorted.entrySet()) {
			Student s =e.getKey();
			Integer ticks = e.getValue();
			DoS d = mDoSes.get(s.getCollege());
			System.out.println(s.getCollege()+" "+s.getCRSID()+" "+s.getSurname()+" "+
		mTicks.get(s) + " "+d.getSurname());
		}
	}
	
	
	
	
}
