package uk.ac.cam.rkh23.Cloning.Deep;

public class DeepExample implements Cloneable {
	
	// Primitives and references
	private int mPrimitive = 7;
	private BlobFish mRef = new BlobFish();
	
	// Arrays of primitives and references
	private int[] mPrimitiveArray = new int[]{1,2,3,4,5};
	private BlobFish[] mRefArray = 
			new BlobFish[] { new BlobFish(), new BlobFish() };
	
	@Override
	public Object clone() throws CloneNotSupportedException {
		DeepExample copy = (DeepExample) super.clone();
		// This next line is redundant
		copy.mPrimitive=this.mPrimitive;
		// References must be cloned
		copy.mRef=(BlobFish)this.mRef.clone();
		
		// Primitives get copied
		copy.mPrimitiveArray=this.mPrimitiveArray.clone();
		
		copy.mRefArray = this.mRefArray.clone(); // shallow
		for (int i =0; i<mRefArray.length; i++) {
			copy.mRefArray[i]=(BlobFish)this.mRefArray[i].clone();
		}
		return copy;
	}
	
}
