package uk.ac.cam.rkh23.Collections;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

import uk.ac.cam.rkh23.Comparing.Person;

public class CollectionExamples {

	
	public static void main(String[] args) {
		
		// A set of Integer objects, kept in sorted order
		TreeSet<Integer> ss = new TreeSet<Integer>();
		ss.add(new Integer(4));
		ss.add(new Integer(3));
		ss.add(new Integer(1));
		ss.add(new Integer(4));
		for (Integer i : ss) System.out.println(i);
		
		// A set of Double objects, kept in hash order
		HashSet<Double> hs = new HashSet<Double>();
		hs.add(new Double(4.0));
		hs.add(new Double(3.0));
		hs.add(new Double(1.0));
		hs.add(new Double(1.0));
		for (Double i : hs) System.out.println(i);
		
		// A map of Integer keys to String values, kept key sorted
		TreeMap<Integer,String> sm = new TreeMap<Integer,String>();
		sm.put(new Integer(5), "D");
		sm.put(new Integer(12), "BO");
		sm.put(new Integer(2), "G");
		for (Integer i : sm.keySet()) 
			System.out.print(sm.get(i));
		System.out.println("");
		
		// A map of Double keys to String values, with keys
		// stored in hash order for fast lookup
		HashMap<Double,String> hm = new HashMap<Double,String>();
		hm.put(new Double(5.0), "D");
		hm.put(new Double(12.0), "BO");
		hm.put(new Double(2.2), "G");
		for (Double i : hm.keySet()) 
			System.out.print(hm.get(i));
	}
}
