(* Modified from Peter Sewell's Lexer.lex for L2 

  added   : fun * ref not - (binary and unary) 
  deleted : val rec 
*) 


{
open Lexing Parser     
   
exception LexicalError of string * int * int (* (message, loc1, loc2) *)
    
fun lexerError lexbuf s = 
   raise LexicalError (s, getLexemeStart lexbuf, getLexemeEnd lexbuf);

exception ThisCannotHappen
}

rule token = parse
    [` ` `\t` `\n` `\r` ]   { token lexbuf }  
  | "%"         {comment lexbuf; token lexbuf} 
  | "*"         { TIMES } 
  | "-"         { MINUS } 
  | "ref"       { REF } 
  | "not"       { NOT } 
  | "fun"       { FUN }
  | "("         { LPAREN }
  | ")"         { RPAREN }
  | "int"       { INT }
  | "bool"      { BOOL }
  | "unit"      { UNIT }
  | "->"        { ARROW }
  | "true"      { TRUE }
  | "false"     { FALSE }
  | "+"         { PLUS }
  | ">="        { GTEQT }
  | "if"        { IF }
  | "then"      { THEN }
  | "else"      { ELSE }
  | ":="        { ASSIGN }
  | "!"         { DEREF }
  | "skip"      { SKIP }
  | ";"         { SEQ }
  | "while"     { WHILE }
  | "do"        { DO }
  | "fn"        { FN }
  | ":"         { COLON }
  | "=>"        { DOUBLEARROW }
  | "let"       { LET }
  | "in"        { IN }
  | "end"       { END }
  | [`-``~`]? [`0`-`9`]+     { INTEGER( case Int.fromString(getLexeme lexbuf) of SOME x => x | NONE => raise ThisCannotHappen) }
  | [`A`-`Z` `a`-`z`] ( [`A`-`Z` `a`-`z` `0`-`9` `'` `_`] ) *  { IDENT(getLexeme lexbuf) }
  | ","         { COMMA }
  | "="         { EQUALS }
  | _           { lexerError lexbuf "Illegal symbol in input" }
  | eof         { EOF }

and comment = parse 
     "\n"       { () } 
  | _           { comment lexbuf } 

;

